/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.JCEManager;
import com.pingidentity.crypto.PkCert;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.CryptoUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.mgmt.AdminSslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SslServerPkCertManager;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public abstract class JCEManagerBase
implements JCEManager {
    private static final Log log = LogFactory.getLog(JCEManagerBase.class);
    private static final String ENABLED_CIPHER_SUITES_KEY_NAME = "enabled-cipher-suites";
    private String[] enabledCipherSuites;

    @Override
    public void initialize() {
        ConfigStore configStore = ConfigStoreFarm.getConfig(this.getConfigName());
        try {
            Map cipherMap = configStore.getMapValue(ENABLED_CIPHER_SUITES_KEY_NAME);
            if (cipherMap.size() > 0) {
                this.enabledCipherSuites = new String[1];
                this.enabledCipherSuites = cipherMap.keySet().toArray(this.enabledCipherSuites);
            }
            log.info((Object)("Using cipher suites defined in " + this.getConfigName() + ".xml"));
        }
        catch (NoSuchValueException e) {
            log.info((Object)"No cipher suites defined - using default list");
        }
        this.checkServerCert();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public boolean allowXmlEncryption() {
        return true;
    }

    @Override
    public boolean allowPrivateKeyImport() {
        return true;
    }

    @Override
    public boolean allowPrivateKeyExport() {
        return false;
    }

    @Override
    public boolean retrieveCertOnSign() {
        return true;
    }

    @Override
    public boolean isFIPSModuleConfigured() {
        return true;
    }

    @Override
    public synchronized String obfuscate(String clearText) {
        return Obfuscator.obfuscate(clearText, this.getLegacyEncryptionAlgorithm());
    }

    @Override
    public synchronized String unobfuscate(String obfuscatedText) {
        return Obfuscator.deobfuscate(obfuscatedText, this.getLegacyEncryptionAlgorithm());
    }

    @Override
    public Cipher getLegacyEncryptionCipher() {
        return CryptoUtil.getCipher((int)1, (String)this.getLegacyEncryptionAlgorithm());
    }

    @Override
    public Cipher getLegacyDecryptionCipher() {
        return CryptoUtil.getCipher((int)2, (String)this.getLegacyEncryptionAlgorithm());
    }

    @Override
    public String getLegacyEncryptionAlgorithm() {
        return "AES";
    }

    @Override
    public SecretKeySpec getLegacySecretKeySpec() {
        return CryptoUtil.getSecretKeySpec((String)this.getLegacyEncryptionAlgorithm());
    }

    @Override
    public String getKeystoreType() {
        return KeyStore.getDefaultType();
    }

    @Override
    public String getKeystoreType(String name) {
        return this.getKeystoreType();
    }

    protected abstract String getConfigName();

    private void checkServerCert() {
        SslServerPkCertManager sslServerPkCertManager = MgmtFactory.getSslServerPkCertManager();
        AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
        if (!sslServerPkCertManager.hasActiveServerPkCert()) {
            if (ModeSupport.getMode() == Mode.CLUSTERED_ENGINE && (!sslServerPkCertManager.isCreateServerPkCertOnEngineNode() || PropertyInfo.isHardwareHSM())) {
                log.debug((Object)"On engine node: skipping auto-create of default server SSL cert.");
            } else if (adminNodeConfigManager.isEnabledAndPassiveNode() && PropertyInfo.isHardwareHSM()) {
                log.debug((Object)"On passive console node: postponing auto-create of default server SSL cert until cluster node information is available.");
            } else {
                log.debug((Object)"Create a default server SSL cert");
                JCEManagerBase.generateDefaultSslServerCert(sslServerPkCertManager);
            }
        }
    }

    public static void generateDefaultSslServerCert(SslServerPkCertManager sslServerPkCertManager) {
        try {
            PkCert cert = new PkCert.Builder().cn("localhost").ou("Development").o("PingIdentity").l("Denver").st("CO").c("US").validDays(3653).keyAlgo("RSA").keySize(2048).certificateType(CertificateGenerator.CertificateType.sslServerCerts).build();
            HashSet<PkCert> certSet = new HashSet<PkCert>();
            certSet.add(cert);
            sslServerPkCertManager.savePkCerts(certSet);
            sslServerPkCertManager.setActiveServerPkCert(cert);
            if (ModeSupport.isConsole()) {
                AdminSslServerPkCertManager adminSslServerPcm = MgmtFactory.getAdminSslServerPkCertManager();
                adminSslServerPcm.setActiveServerPkCert(cert);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            log.error((Object)"Unable to create a default server SSL certificate", (Throwable)e);
        }
    }

    @Override
    public boolean isEnforceFIPSKeySizes() {
        return false;
    }

    @Override
    public boolean isUseLegacyRsaSsaPssAlgorithmNames(PkCert pkCert) {
        return PropertyInfo.isHSM() && (pkCert.isStoredOnHSM() == null || pkCert.isStoredOnHSM() != false);
    }
}

