/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.configservice.StreamLoader;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.CertificateServiceImpl;
import com.pingidentity.crypto.JCEManager;
import com.pingidentity.crypto.LunaPartitions;
import com.pingidentity.crypto.LunaUtil;
import com.safenetinc.luna.LunaSlotManager;
import com.safenetinc.luna.provider.param.LunaNamedCurve;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.CoreConfig;

public class LunaCertificateServiceImpl
extends CertificateServiceImpl {
    private static final String PROVIDER = "LunaProvider";
    private static final String EC_NAME = "ECDSA";
    private final CoreConfig coreConfig;
    private final LunaPartitions lunaPartitions;

    public LunaCertificateServiceImpl(JCEManager jceManager, CoreConfig coreConfig, SysDirInfo sysDirInfo, StreamLoader streamLoader, LunaPartitions lunaPartitions) {
        super(jceManager, coreConfig, sysDirInfo, streamLoader);
        this.coreConfig = coreConfig;
        this.lunaPartitions = lunaPartitions;
        this.setDefaultSlot();
    }

    @Override
    protected void clearCachedKeystores() {
        super.clearCachedKeystores();
    }

    @Override
    protected KeyStore getKeystore(String name, String pass) {
        if ("Luna".equals(this.getKeystoreType(name))) {
            pass = LunaUtil.getPassword();
        }
        return super.getKeystore(name, pass);
    }

    @Override
    public Enumeration<String> getAliases(String keystoreName, KeyStore keystore) throws KeyStoreException {
        if ("Luna".equals(keystore.getType()) && StringUtils.isNotBlank((String)keystoreName)) {
            return Collections.enumeration(new HashSet<String>(this.coreConfig.getAliases(keystoreName)));
        }
        return keystore.aliases();
    }

    @Override
    public InputStream getKeystoreInputStream(String keystoreName) throws FileNotFoundException {
        InputStream returnStream;
        if ("Luna".equals(this.getKeystoreType(keystoreName))) {
            String slotOrLabel = this.lunaPartitions.getDefaultPartitionSlotOrLabel();
            returnStream = new ByteArrayInputStream(slotOrLabel.getBytes(StandardCharsets.UTF_8));
        } else {
            returnStream = super.getKeystoreInputStream(keystoreName);
        }
        return returnStream;
    }

    @Override
    public KeyStore getTrustHSMKeystore() {
        return super.getTrustKeystore();
    }

    @Override
    public void writeTrustHSMKeystore(KeyStore keystore) {
        super.writeTrustKeystore(keystore);
    }

    @Override
    public void writeDsigHSMKeystore(KeyStore keystore) {
    }

    @Override
    public void writeSslServerHSMKeystore(KeyStore keystore) {
    }

    @Override
    public void writeSslHSMKeystore(KeyStore keystore) {
    }

    @Override
    public void writeGeneralHSMKeystore(KeyStore keystore) {
    }

    @Override
    public KeyPair generateKeyPair(String id, String keyAlgorithm, int keySize, Boolean isHSMProvider, CertificateGenerator.CertificateType certificateType) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (isHSMProvider != null && !isHSMProvider.booleanValue()) {
            return super.generateKeyPair(id, keyAlgorithm, keySize, false, null);
        }
        if ("EC".equals(keyAlgorithm)) {
            keyAlgorithm = EC_NAME;
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyAlgorithm, PROVIDER);
            if (EC_NAME.equals(keyAlgorithm)) {
                keyGen.initialize((AlgorithmParameterSpec)Objects.requireNonNull(LunaNamedCurve.getECParameterSpec((int)keySize)), this.prng);
            } else {
                keyGen.initialize(keySize, this.prng);
            }
            return keyGen.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchProviderException e) {
            throw new RuntimeException("Unexpected error initializing key pair generator", e);
        }
    }

    private void setDefaultSlot() {
        LunaSlotManager slotManager = LunaSlotManager.getInstance();
        slotManager.setThreadLocalDefaultSlot(false);
        int defaultSlot = LunaCertificateServiceImpl.getSlotFromDesignation(this.lunaPartitions.getDefaultPartitionSlotOrLabel());
        slotManager.setDefaultSlot(defaultSlot);
    }

    private static int getSlotFromDesignation(String designation) {
        int slotNumber;
        block3: {
            block2: {
                slotNumber = 0;
                if (!StringUtils.startsWithIgnoreCase((String)designation, (String)"slot:")) break block2;
                String slotNumberString = StringUtils.removeStartIgnoreCase((String)designation, (String)"slot:");
                if (!StringUtils.isNumeric((String)slotNumberString)) break block3;
                slotNumber = Integer.parseInt(slotNumberString);
                break block3;
            }
            if (StringUtils.startsWithIgnoreCase((String)designation, (String)"tokenlabel:")) {
                LunaSlotManager slotManager = LunaSlotManager.getInstance();
                String tokenLabel = StringUtils.removeStartIgnoreCase((String)designation, (String)"tokenlabel:");
                for (int aSlotNumber : slotManager.getSlotList()) {
                    if (!StringUtils.equals((String)slotManager.getTokenLabel(aSlotNumber), (String)tokenLabel)) continue;
                    slotNumber = aSlotNumber;
                    break;
                }
            }
        }
        return slotNumber;
    }

    @Override
    protected void tryInitializeKeyGenerator(String keyAlgorithm, int keySize) throws NoSuchAlgorithmException {
        if ("EC".equals(keyAlgorithm)) {
            keyAlgorithm = EC_NAME;
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyAlgorithm, PROVIDER);
            if (EC_NAME.equals(keyAlgorithm)) {
                keyGen.initialize((AlgorithmParameterSpec)Objects.requireNonNull(LunaNamedCurve.getECParameterSpec((int)keySize)), this.prng);
            } else {
                keyGen.initialize(keySize, this.prng);
            }
        }
        catch (InvalidAlgorithmParameterException | NoSuchProviderException e) {
            throw new RuntimeException("Unexpected error initializing key pair generator", e);
        }
    }

    @Override
    public int getMaxValidDays() {
        return 10950;
    }

    @Override
    public String getHSMProviderName() {
        return PROVIDER;
    }

    @Override
    public PrivateKey findPrivateKeyById(String id) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new UnsupportedOperationException("findPrivateKeyById is not supported for Luna provider");
    }
}

