/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.PasswordFile;
import com.pingidentity.crypto.luna.AbstractLunaFactory;
import com.pingidentity.crypto.luna.LunaFactory;
import com.pingidentity.crypto.luna.type.LunaManagerType;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;

public class LunaUtil {
    private static Log log = LogFactory.getLog(LunaUtil.class);
    private static final AbstractLunaFactory lunaFactory = LunaFactory.getInstance();

    public static synchronized boolean tryReinitializeLunaAPI() {
        boolean reinitialized = false;
        LunaManagerType lunaMgr = null;
        if (lunaFactory != null) {
            lunaMgr = lunaFactory.createLunaSlotManager();
        }
        if (lunaMgr != null) {
            log.debug((Object)"Trying to reinitialize LunaAPI...");
            lunaMgr.reinitialize();
            if (lunaMgr.isLoggedIn()) {
                log.debug((Object)"lunaMgr.Logout()...");
                lunaMgr.logout();
            }
            log.debug((Object)"lunaMgr.Login()...");
            String hsmPwd = LunaUtil.getPassword();
            lunaMgr.login(hsmPwd);
            reinitialized = true;
        } else {
            log.debug((Object)"LunaTokenManager not available");
        }
        return reinitialized;
    }

    public static synchronized boolean handleException(Exception ex) {
        boolean reinitialized = false;
        if (lunaFactory.isLunaException(ex)) {
            reinitialized = LunaUtil.tryReinitializeLunaAPI();
        } else {
            log.error((Object)"Exception", (Throwable)ex);
        }
        return reinitialized;
    }

    protected static String getPassword() {
        SysDirInfo sd = GlobalRegistry.getService(SysDirInfo.class);
        File dataDir = new File(sd.getDataDirectory());
        return PasswordFile.getAndDeobfuscateHSMPassword(dataDir.getAbsolutePath());
    }

    public static synchronized void ping() {
        try {
            SecureRandom random = SecureRandom.getInstance("LunaRNG", lunaFactory.getProvider());
            random.nextInt();
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage());
        }
        catch (NoSuchProviderException e) {
            log.error((Object)e.getMessage());
        }
    }
}

