/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.configservice.StreamLoader;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.CertificateServiceImpl;
import com.pingidentity.crypto.JCEManager;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.commons.lang3.NotImplementedException;
import org.sourceid.config.CoreConfig;

public class NcipherCertificateServiceImpl
extends CertificateServiceImpl {
    private static final String PROVIDER = "nCipherKM";
    public static final String NCIPHER_EC_NAME = "ECDSA";

    public NcipherCertificateServiceImpl(JCEManager jceManager, CoreConfig coreConfig, SysDirInfo sysDirInfo, StreamLoader streamLoader) {
        super(jceManager, coreConfig, sysDirInfo, streamLoader);
    }

    @Override
    public KeyPair generateKeyPair(String id, String keyAlgorithm, int keySize, Boolean isHSMProvider, CertificateGenerator.CertificateType certificateType) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (isHSMProvider != null && !isHSMProvider.booleanValue()) {
            return super.generateKeyPair(id, keyAlgorithm, keySize, isHSMProvider, null);
        }
        if ("EC".equals(keyAlgorithm)) {
            keyAlgorithm = NCIPHER_EC_NAME;
        }
        boolean retry = false;
        while (true) {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyAlgorithm, PROVIDER);
                keyGen.initialize(keySize, this.prng);
                KeyPair keyPair = keyGen.generateKeyPair();
                retry = false;
                return keyPair;
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("Unable to create keypair.  nCipherKM provider not found.", e);
            }
            catch (Exception e) {
                if (!"ncipher".equalsIgnoreCase(System.getProperty("pf.hsm.mode")) || retry) {
                    throw new RuntimeException(e);
                }
                this.log.warn((Object)("Error occured while generating keypair.  HSM may have failed.  Retrying.  Error Message=" + e.getMessage()));
                retry = true;
                if (retry) continue;
                return null;
            }
            break;
        }
    }

    @Override
    protected void tryInitializeKeyGenerator(String keyAlgorithm, int keySize) throws NoSuchAlgorithmException {
        if ("EC".equals(keyAlgorithm)) {
            keyAlgorithm = NCIPHER_EC_NAME;
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyAlgorithm, PROVIDER);
            keyGen.initialize(keySize, this.prng);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Unable to initialize key generator. nCipherKM provider not found.", e);
        }
    }

    @Override
    public String getHSMProviderName() {
        return PROVIDER;
    }

    @Override
    protected String getKeyAlgorithm(KeyPair keyPair) {
        String keyPairAlgorithm = super.getKeyAlgorithm(keyPair);
        if (NCIPHER_EC_NAME.equals(keyPairAlgorithm)) {
            keyPairAlgorithm = "EC";
        }
        return keyPairAlgorithm;
    }

    @Override
    public PrivateKey findPrivateKeyById(String id) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new NotImplementedException("method is not implemented for nCipher provider");
    }
}

