/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.JCEManagerBase;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class NcipherJCEManager
extends JCEManagerBase {
    private static final Log log = LogFactory.getLog(NcipherJCEManager.class);
    public static final String NCIPHER_KEYSTORE_TYPE = "nCipher.sworld";
    private boolean allowPrivateKeyImport = true;
    private boolean allowPrivateKeyImportTested;

    @Override
    public String getKeystoreType() {
        return NCIPHER_KEYSTORE_TYPE;
    }

    @Override
    public boolean allowLinkAndStoreKeys() {
        return false;
    }

    @Override
    public synchronized boolean allowPrivateKeyImport() {
        if (!this.allowPrivateKeyImportTested) {
            PkCertManager pkCertManager = MgmtFactory.getDsigPkCertManager();
            KeyPairGenerator keyGen = null;
            HashSet<PkCert> dsigCertsWithTestCert = null;
            Set<PkCert> originalDsigCerts = pkCertManager.getPkCerts();
            try {
                keyGen = KeyPairGenerator.getInstance("RSA", SecurityProviderUtil.getSunRsaSignProviderOrEquivalent());
                keyGen.initialize(2048);
                KeyPair keyPair = keyGen.generateKeyPair();
                X509Certificate cert = GlobalRegistry.getService(CertificateService.class).createSelfSignedCert("key-import-test", null, null, null, null, "US", 1, keyPair, null, null, false);
                PkCert pkCertToImport = new PkCert("key-import-test", cert, keyPair.getPrivate());
                dsigCertsWithTestCert = new HashSet<PkCert>();
                dsigCertsWithTestCert.addAll(originalDsigCerts);
                dsigCertsWithTestCert.add(pkCertToImport);
            }
            catch (Exception e) {
                log.error((Object)"Unable to create PkCert needed to test if private key import is supported. Assuming import will be allowed.", (Throwable)e);
            }
            if (dsigCertsWithTestCert != null) {
                try {
                    pkCertManager.savePkCerts(dsigCertsWithTestCert);
                }
                catch (Exception e) {
                    log.info((Object)("Key import not allowed in this configuration. Provider's message=" + e.getMessage()));
                    this.allowPrivateKeyImport = false;
                }
                pkCertManager.savePkCerts(originalDsigCerts);
                this.allowPrivateKeyImportTested = true;
            }
        }
        return this.allowPrivateKeyImport;
    }

    @Override
    protected String getConfigName() {
        return "com.pingidentity.crypto.NcipherJCEManager";
    }
}

