/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.OCSPChecker;
import com.pingidentity.crypto.OCSPCheckerSupport;
import com.pingidentity.crypto.OCSPContinueOnException;
import com.pingidentity.crypto.OCSPFailoverToCRLException;
import com.pingidentity.crypto.OCSPResponseCache;
import com.pingidentity.crypto.OCSPRuntimeException;
import com.pingidentity.crypto.RevocationCheckerConstants;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.crypto.TaggedCertificate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.sourceid.config.ConfigStore;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class OCSPCheckerImpl
implements OCSPChecker,
RevocationCheckerConstants {
    private static int DEFAULT_GRACE_MINS = 10;
    private Log log = LogFactory.getLog(this.getClass());
    private ConfigStore config = null;
    private Map<String, X509Certificate> certCache = new HashMap<String, X509Certificate>();
    private OCSPResponseCache respCache = null;

    public OCSPCheckerImpl(ConfigStore config) {
        this.log.info((Object)"OCSP is enabled");
        this.config = config;
        this.respCache = new OCSPResponseCache(config);
    }

    private OCSPCheckerSupport.ACTION getConfiguredAction(String itemName) {
        String value = this.config.getStringValue(itemName, OCSPCheckerSupport.ACTION.FAILOVER.toString());
        return OCSPCheckerSupport.ACTION.valueOf(value);
    }

    @Override
    public void check(X509Certificate[] chain) throws RevokedCertException, OCSPFailoverToCRLException {
        if (chain == null) {
            return;
        }
        for (int idx = 0; idx < chain.length; ++idx) {
            X509Certificate x509Certificate = chain[idx];
            int next = idx + 1;
            X509Certificate issuer = chain.length > next ? chain[next] : null;
            this.check(x509Certificate, issuer);
        }
    }

    @Override
    public void check(X509Certificate cert, X509Certificate issuer) throws RevokedCertException, OCSPFailoverToCRLException {
        if (!(OCSPCheckerSupport.isSelfSigned(cert) || cert.getBasicConstraints() != -1 && this.config.getBooleanValue("OCSP-check-only-end-entity", true))) {
            this.validate(cert, issuer);
        }
    }

    public void validate(X509Certificate endCert, X509Certificate issuer) throws RevokedCertException, OCSPFailoverToCRLException {
        PkCertAndConnectionCertManager dsigPkCertManager;
        Cert cert;
        X509Certificate responderCert = null;
        String responderCertAlias = this.config.getStringValue("OCSP-responder-cert-alias", null);
        if (!StringUtils.isEmpty((String)responderCertAlias) && (responderCert = this.certCache.get(responderCertAlias)) == null && (cert = (dsigPkCertManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager()).getCert(responderCertAlias)) != null) {
            responderCert = cert.getX509Certificate();
            this.certCache.put(responderCertAlias, responderCert);
        }
        this.validate(endCert, issuer, responderCert);
    }

    public void validate(X509Certificate endCert, X509Certificate issuer, X509Certificate responderCert) throws RevokedCertException, OCSPFailoverToCRLException {
        block42: {
            OCSPCheckerSupport.ACTION actionOnUnsuccessfulResponse;
            OCSPCheckerSupport.ACTION actionOnOtherErrors = actionOnUnsuccessfulResponse = this.getConfiguredAction("OCSP-action-on-unsuccessful-response");
            try {
                Date nextUpdate;
                SingleResp[] singleResps;
                String responderUrl = this.getResponderUrl(endCert);
                if (StringUtils.isEmpty((String)responderUrl)) {
                    if (this.config.getBooleanValue("crl-enable", true) && endCert.getExtensionValue("2.5.29.31") != null) {
                        throw new OCSPFailoverToCRLException("No OCSP responder URL");
                    }
                    this.log.debug((Object)("No OCSP responder URL found in cert: " + endCert.getSubjectDN()));
                    return;
                }
                if (this.respCache.get(endCert) != null) {
                    SingleResp singleResp = this.respCache.get(endCert);
                    this.checkStatus(endCert, singleResp);
                    return;
                }
                if (issuer == null) {
                    issuer = OCSPCheckerSupport.getIssuer(endCert);
                    if (issuer == null) {
                        OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "The issuer of cert [" + endCert.getSubjectDN() + "] is not in the trusted ca list. OCSP checking cannot proceed.");
                    }
                } else if (!OCSPCheckerSupport.isValidIssuer(endCert, issuer)) {
                    OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "The provided issuer [" + issuer.getSubjectDN() + "] is invalid or did not issue the target certificate [" + endCert.getSubjectDN() + "]");
                }
                CertificateID certId = null;
                try {
                    JcaDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
                    DigestCalculatorProvider digestCalculatorProvider = digestCalculatorProviderBuilder.build();
                    DigestCalculator digestCalculator = digestCalculatorProvider.get(CertificateID.HASH_SHA1);
                    certId = new CertificateID(digestCalculator, new X509CertificateHolder(issuer.getEncoded()), endCert.getSerialNumber());
                }
                catch (IOException | CertificateEncodingException e) {
                    this.log.error((Object)"Unexpected error converting issuer certificate", (Throwable)e);
                    OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "Error converting issuer certificate");
                }
                byte[] nonce = null;
                boolean addNonce = this.config.getBooleanValue("OCSP-requester-add-nonce", true);
                if (addNonce) {
                    nonce = new byte[16];
                    SecurityProviderUtil.getSecureRandom().nextBytes(nonce);
                }
                OCSPReq request = this.generateRequest(certId, nonce);
                OCSPResp response = null;
                try {
                    this.log.debug((Object)("Sending OCSP request for cert " + endCert.getSubjectDN() + " to the responder."));
                    response = this.sendRequest(endCert, request);
                }
                catch (RuntimeException e) {
                    this.log.error((Object)"Unexpected error sending OCSP request", (Throwable)e);
                    OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "Error occurred trying to get the OCSP response: " + e.getMessage());
                }
                OCSPCheckerSupport.checkOcspResponseStatus(response.getStatus(), actionOnUnsuccessfulResponse);
                BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
                if (basicResponse == null) {
                    OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "OCSP response: BasicOCSPResp is null");
                }
                X509Certificate[] providedCerts = this.convert(basicResponse.getCerts());
                ArrayList<TaggedCertificate> candidateVerificationCerts = new ArrayList<TaggedCertificate>();
                if (providedCerts == null || providedCerts.length == 0) {
                    candidateVerificationCerts.add(new TaggedCertificate(issuer, "issuer certificate"));
                    if (responderCert != null) {
                        candidateVerificationCerts.add(new TaggedCertificate(responderCert, "default responder certificate"));
                    }
                } else if (responderCert != null && responderCert.equals(providedCerts[0])) {
                    candidateVerificationCerts.add(new TaggedCertificate(responderCert, "default responder certificate (provided)"));
                } else if (issuer.equals(providedCerts[0])) {
                    candidateVerificationCerts.add(new TaggedCertificate(issuer, "issuer certificate (provided)"));
                } else if (this.isAuthorizedResponder(providedCerts[0], issuer)) {
                    candidateVerificationCerts.add(new TaggedCertificate(providedCerts[0], "authorized responder certificate (provided)"));
                } else if (!this.config.getBooleanValue("OCSP-enforce-responder-key-usage-check", true) && OCSPCheckerSupport.isTrusted(providedCerts)) {
                    candidateVerificationCerts.add(new TaggedCertificate(providedCerts[0], "trusted certificate (provided)"));
                } else {
                    OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "The OCSP responder is untrusted");
                }
                boolean signatureVerified = false;
                for (TaggedCertificate candidate : candidateVerificationCerts) {
                    try {
                        if (!basicResponse.isSignatureValid(new JcaContentVerifierProviderBuilder().build(candidate.getCertificate()))) continue;
                        this.log.debug((Object)("Signature verified with " + candidate.getTag()));
                        signatureVerified = true;
                        break;
                    }
                    catch (OCSPException e) {
                        this.log.debug((Object)("Failed to verify response signature with " + candidate.getTag() + ": " + e.getMessage()));
                    }
                }
                if (!signatureVerified) {
                    OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "Invalid signature from OCSP responder");
                }
                if (addNonce) {
                    OCSPCheckerSupport.checkNonce(nonce, basicResponse, actionOnUnsuccessfulResponse);
                }
                if ((singleResps = basicResponse.getResponses()) == null || singleResps.length == 0) {
                    OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "OCSP response: BasicOCSPResp is null");
                }
                SingleResp singleResp = null;
                for (int i = 0; i < singleResps.length; ++i) {
                    if (!certId.equals((Object)singleResps[i].getCertID())) continue;
                    singleResp = singleResps[i];
                    break;
                }
                if (singleResp == null) {
                    OCSPCheckerSupport.bailOut(actionOnOtherErrors, "OCSP response: the response is not for the requested cert[" + endCert.getSubjectDN() + "]");
                }
                Date thisUpdate = singleResp.getThisUpdate();
                Date now = new Date();
                if (thisUpdate != null) {
                    int thisUpdateGracePeriod = this.config.getIntValue("OCSP-thisupdate-grace-period", DEFAULT_GRACE_MINS);
                    Date adjustedThisUpdate = new Date(thisUpdate.getTime() - 60000L * (long)thisUpdateGracePeriod);
                    if (now.before(adjustedThisUpdate)) {
                        OCSPCheckerSupport.bailOut(actionOnOtherErrors, "OCSP response: thisUpdate is out of bound");
                    }
                }
                if ((nextUpdate = singleResp.getNextUpdate()) != null) {
                    int nextUpdateGracePeriod = this.config.getIntValue("OCSP-nextupdate-grace-period", DEFAULT_GRACE_MINS);
                    Date adjustedNextUpdate = new Date(nextUpdate.getTime() + 60000L * (long)nextUpdateGracePeriod);
                    if (now.after(adjustedNextUpdate)) {
                        OCSPCheckerSupport.bailOut(actionOnOtherErrors, "OCSP response: nextUpdate is out of bound: " + nextUpdate);
                    }
                }
                this.respCache.put(endCert, singleResp);
                this.log.debug((Object)("OCSP response for cert " + endCert.getSubjectDN() + " has been added to the cache."));
                this.checkStatus(endCert, singleResp);
            }
            catch (OCSPContinueOnException e) {
                this.log.info((Object)(e.getMessage() + " [" + endCert.getSubjectDN() + "]"));
            }
            catch (OperatorCreationException e) {
                this.log.error((Object)"Unexpected error during validation", (Throwable)e);
                throw new OCSPRuntimeException(e);
            }
            catch (OCSPException e) {
                this.log.error((Object)"OCSPException during validation", (Throwable)e);
                if (actionOnOtherErrors == OCSPCheckerSupport.ACTION.CONTINUE) {
                    this.log.info((Object)("Continue with " + e.getMessage() + " [" + endCert.getSubjectDN() + "]"));
                }
                if (actionOnOtherErrors == OCSPCheckerSupport.ACTION.FAIL) {
                    throw new RevokedCertException(e.getMessage());
                }
                if (actionOnOtherErrors != OCSPCheckerSupport.ACTION.FAILOVER) break block42;
                throw new OCSPFailoverToCRLException(e.getMessage());
            }
        }
    }

    private boolean isAuthorizedResponder(X509Certificate responderCert, X509Certificate targetCertIssuer) {
        X509CertificateHolder responderCertHolder;
        try {
            responderCertHolder = new X509CertificateHolder(responderCert.getEncoded());
        }
        catch (IOException | CertificateEncodingException e) {
            this.log.error((Object)"Unexpected error decoding responder certificate", (Throwable)e);
            return false;
        }
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.fromExtensions((Extensions)responderCertHolder.getExtensions());
        if (extendedKeyUsage == null || !extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_OCSPSigning)) {
            this.log.debug((Object)"Responder certificate missing OCSP signing extended key usage");
            return false;
        }
        try {
            responderCert.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            this.log.debug((Object)"Responder certificate is expired or not yet valid");
            return false;
        }
        try {
            responderCert.verify(targetCertIssuer.getPublicKey());
        }
        catch (GeneralSecurityException e) {
            this.log.debug((Object)("Failed to verify responder certificate signature with target certificate issuer " + targetCertIssuer.getSubjectDN() + ": " + e));
            return false;
        }
        return true;
    }

    private X509Certificate[] convert(X509CertificateHolder[] holders) {
        if (holders == null) {
            return null;
        }
        return Arrays.asList(holders).stream().map(this::convert).collect(Collectors.toList()).toArray(new X509Certificate[0]);
    }

    private X509Certificate convert(X509CertificateHolder holder) {
        try {
            return new JcaX509CertificateConverter().getCertificate(holder);
        }
        catch (CertificateException e) {
            throw new OCSPRuntimeException("Unexpected error converting certificate", e);
        }
    }

    private void checkStatus(X509Certificate endCert, SingleResp singleResp) throws RevokedCertException, OCSPFailoverToCRLException, OCSPContinueOnException {
        if (singleResp != null) {
            CertificateStatus status = singleResp.getCertStatus();
            if (status == null) {
                this.log.debug((Object)("Cert " + endCert.getSubjectDN() + " has been validated via OCSP."));
            } else {
                if (status instanceof RevokedStatus) {
                    String msg = "OCSP: cert has been revoked[" + endCert.getSubjectDN() + "]";
                    this.log.info((Object)msg);
                    throw new RevokedCertException(msg);
                }
                OCSPCheckerSupport.ACTION actionOnStatusUnknown = this.getConfiguredAction("OCSP-action-on-status-unknown");
                OCSPCheckerSupport.bailOut(actionOnStatusUnknown, "OCSP response: cert status unknown [" + endCert.getSubjectDN() + "]");
            }
        }
    }

    private OCSPReq generateRequest(CertificateID certId, byte[] nonce) throws OCSPException {
        OCSPReqBuilder builder = new OCSPReqBuilder();
        builder.addRequest(certId);
        if (nonce != null) {
            Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce));
            builder.setRequestExtensions(new Extensions(extension));
        }
        OCSPReq req = builder.build();
        return req;
    }

    private OCSPResp sendRequest(X509Certificate endCert, OCSPReq request) throws OCSPFailoverToCRLException, RevokedCertException, OCSPContinueOnException {
        OCSPResp ocspResponse = null;
        String responderUrl = this.getResponderUrl(endCert);
        if (StringUtils.isEmpty((String)responderUrl)) {
            OCSPCheckerSupport.bailOut(this.getConfiguredAction("OCSP-action-on-status-unknown"), "No OCSP responder URL");
            return null;
        }
        if (responderUrl.startsWith("http")) {
            ocspResponse = this.sendHttpRequest(responderUrl, request);
        } else {
            OCSPCheckerSupport.bailOut(this.getConfiguredAction("OCSP-action-on-responder-unavailable"), "The transport mechanism is not supported yet." + responderUrl);
        }
        return ocspResponse;
    }

    private OCSPResp sendHttpRequest(String responderUrl, OCSPReq request) throws OCSPFailoverToCRLException, RevokedCertException, OCSPContinueOnException {
        OCSPResp ocspResponse = null;
        try {
            URL url = new URL(responderUrl);
            HttpURLConnection con = null;
            String proxyHost = this.config.getStringValue("proxy-host", null);
            int proxyPort = this.config.getIntValue("proxy-port", 0);
            if (proxyHost != null && !"".equals(proxyHost) && proxyPort > 0) {
                InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, sockAddr);
                con = (HttpURLConnection)url.openConnection(proxy);
            } else {
                con = (HttpURLConnection)url.openConnection();
            }
            OCSPCheckerSupport.disableRevocationChecking(con);
            int connectionTimeoutSeconds = this.config.getIntValue("OCSP-connection-timeout-secs", 20);
            if (connectionTimeoutSeconds > 0) {
                int connectionTimeoutMillis = connectionTimeoutSeconds * 1000;
                con.setConnectTimeout(connectionTimeoutMillis);
                con.setReadTimeout(connectionTimeoutMillis);
            }
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            con.setRequestProperty("Accept", "application/ocsp-response");
            con.setDoOutput(true);
            OutputStream out = con.getOutputStream();
            out.write(request.getEncoded());
            out.close();
            if (con.getResponseCode() != 200 || !con.getContentType().equals("application/ocsp-response")) {
                this.log.warn((Object)String.format("Bad HTTP response (code %d, content type '%s') from OCSP endpoint %s", con.getResponseCode(), con.getContentType(), responderUrl));
            }
            InputStream in = (InputStream)con.getContent();
            byte[] response = this.readBytes(in);
            ocspResponse = new OCSPResp(response);
        }
        catch (IOException e) {
            String message = "Error accessing OCSP endpoint " + responderUrl + " " + e.getMessage();
            OCSPCheckerSupport.ACTION actionOnResponderUnavailable = this.getConfiguredAction("OCSP-action-on-responder-unavailable");
            OCSPCheckerSupport.bailOut(actionOnResponderUnavailable, message);
        }
        return ocspResponse;
    }

    private byte[] readBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }

    private String getResponderUrl(X509Certificate cert) {
        String responderUrl = this.config.getStringValue("OCSP-responder-URL", null);
        boolean overrideAIA = this.config.getBooleanValue("OCSP-always-use-responder-URL-in-conf", false);
        String urlInCert = this.getOcspURL(cert);
        if (urlInCert != null && !overrideAIA) {
            responderUrl = urlInCert;
        }
        return responderUrl;
    }

    private String getOcspURL(X509Certificate cert) {
        byte[] bytes = cert.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (bytes != null) {
            try {
                ASN1OctetString octs = (ASN1OctetString)new ASN1InputStream(bytes).readObject();
                ASN1Primitive obj = new ASN1InputStream(octs.getOctets()).readObject();
                AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)obj);
                for (AccessDescription ad : aia.getAccessDescriptions()) {
                    GeneralName gn;
                    if (!ad.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.ocspAccessMethod) || (gn = ad.getAccessLocation()).getTagNo() != 6) continue;
                    DERIA5String str = DERIA5String.getInstance((Object)gn.getName());
                    return str.getString();
                }
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

