/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.OCSPContinueOnException;
import com.pingidentity.crypto.OCSPFailoverToCRLException;
import com.pingidentity.crypto.RevokedCertException;
import com.pingidentity.crypto.X509CertPathValidatorSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertSelector;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class OCSPCheckerSupport {
    public static final int OCSP_RESPONSE_STATUS_successful = 0;
    public static final int OCSP_RESPONSE_STATUS_malformedRequest = 1;
    public static final int OCSP_RESPONSE_STATUS_internalError = 2;
    public static final int OCSP_RESPONSE_STATUS_tryLater = 3;
    public static final int OCSP_RESPONSE_STATUS_sigRequired = 5;
    public static final int OCSP_RESPONSE_STATUS_unauthorized = 6;
    private static Log log = LogFactory.getLog((String)OCSPCheckerSupport.class.getName());

    public static void checkOcspResponseStatus(int status, ACTION actionOnUnsuccessfulResponse) throws OCSPFailoverToCRLException, RevokedCertException, OCSPContinueOnException {
        if (status != 0) {
            String message = null;
            if (status == 1) {
                message = "OCSP response status: malformedRequest";
            } else if (status == 2) {
                message = "OCSP response status: internalError";
            } else if (status == 3) {
                message = "OCSP response status: tryLater";
            } else if (status == 5) {
                message = "OCSP response status: sigRequired";
            } else if (status == 6) {
                message = "OCSP response status: unauthorized";
            }
            OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, message);
        }
    }

    public static void bailOut(ACTION action, String message) throws OCSPFailoverToCRLException, RevokedCertException, OCSPContinueOnException {
        log.warn((Object)message);
        if (action == ACTION.CONTINUE) {
            throw new OCSPContinueOnException(message);
        }
        if (action == ACTION.FAIL) {
            throw new RevokedCertException(message);
        }
        if (action == ACTION.FAILOVER) {
            throw new OCSPFailoverToCRLException(message);
        }
        throw new RuntimeException("Action was not found. Unable to exit gracefully.");
    }

    public static void checkNonce(byte[] nonceInRequest, BasicOCSPResp basicResponse, ACTION actionOnUnsuccessfulResponse) throws OCSPFailoverToCRLException, RevokedCertException, OCSPContinueOnException {
        Extension extension = basicResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (extension == null) {
            OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "The OCSP responder does not support nonce. Please uncheck 'Do NOT allow Responder to use cached responses' in your OCSP configuration.");
        } else {
            byte[] resNonce = extension.getExtnValue().getOctets();
            if (!Arrays.equals(nonceInRequest, resNonce)) {
                OCSPCheckerSupport.bailOut(actionOnUnsuccessfulResponse, "OCSP response: incorrect nonce");
            }
        }
    }

    public static boolean isTrusted(X509Certificate[] certs) {
        TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
        Set<TrustAnchor> trustAnchors = trustedCAsManager.getAllTrustAnchors();
        if (Util.isEmpty(trustAnchors)) {
            return false;
        }
        X509CertPathValidatorSupport pathValidator = new X509CertPathValidatorSupport(certs, true);
        pathValidator.addTrustAnchors(trustAnchors);
        return pathValidator.isPathValid();
    }

    public static void write2File(String fname, byte[] data) {
        try {
            FileOutputStream out = new FileOutputStream(new File(fname));
            out.write(data);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        boolean selfSigned = false;
        if (cert != null && cert.getSubjectDN().equals(cert.getIssuerDN())) {
            selfSigned = true;
        }
        return selfSigned;
    }

    public static X509Certificate getIssuer(X509Certificate userCert) {
        TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();
        Set<TrustAnchor> trustAnchors = trustedCAsManager.getTrustAnchorsByDN(userCert.getIssuerX500Principal());
        for (TrustAnchor anchor : trustAnchors) {
            X509Certificate trustedCert = anchor.getTrustedCert();
            if (!OCSPCheckerSupport.isValidIssuer(userCert, trustedCert)) continue;
            return trustedCert;
        }
        return null;
    }

    public static boolean isValidIssuer(X509Certificate target, X509Certificate candidateIssuer) {
        if (!target.getIssuerX500Principal().equals(candidateIssuer.getSubjectX500Principal())) {
            return false;
        }
        try {
            candidateIssuer.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            log.debug((Object)("Candidate issuer certificate is expired or not yet valid: " + candidateIssuer.getSubjectDN()));
            return false;
        }
        try {
            target.verify(candidateIssuer.getPublicKey());
        }
        catch (GeneralSecurityException e) {
            log.debug((Object)("Failed to verify target certificate signature with candidate issuer certificate " + candidateIssuer.getSubjectDN() + ": " + e));
            return false;
        }
        return true;
    }

    public static void disableRevocationChecking(URLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            try {
                HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                PKIXBuilderParameters params = new PKIXBuilderParameters(MgmtFactory.getTrustedCAsManager().getAllTrustAnchors(), (CertSelector)new X509CertSelector());
                params.setRevocationEnabled(false);
                trustManagerFactory.init(new CertPathTrustManagerParameters(params));
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(null, trustManagerFactory.getTrustManagers(), null);
                httpsConn.setSSLSocketFactory(tlsContext.getSocketFactory());
            }
            catch (InvalidAlgorithmParameterException | KeyManagementException | NoSuchAlgorithmException e) {
                log.error((Object)"Unexpected error disabling revocation checking", (Throwable)e);
            }
        }
    }

    public static enum ACTION {
        CONTINUE,
        FAIL,
        FAILOVER;

    }
}

