/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.RevocationChecker;
import com.pingidentity.crypto.RevokedCertException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sourceid.config.GlobalRegistry;

public class PFRevocationChecker
extends PKIXRevocationChecker {
    private X509Certificate prevCert;

    public static PKIXParameters addCheckerToParams(PKIXParameters pkixParameters) {
        if (pkixParameters.isRevocationEnabled()) {
            pkixParameters = (PKIXParameters)pkixParameters.clone();
            ArrayList<PKIXCertPathChecker> checkers = new ArrayList<PKIXCertPathChecker>(pkixParameters.getCertPathCheckers());
            if (!checkers.stream().anyMatch(PFRevocationChecker.class::isInstance)) {
                checkers.removeIf(PKIXRevocationChecker.class::isInstance);
                checkers.add(new PFRevocationChecker());
            }
            pkixParameters.setCertPathCheckers(checkers);
            pkixParameters.setRevocationEnabled(false);
        }
        return pkixParameters;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking is not supported by this checker");
        }
        this.prevCert = null;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public List<CertPathValidatorException> getSoftFailExceptions() {
        return Collections.emptyList();
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        if (!(cert instanceof X509Certificate)) {
            throw new CertPathValidatorException("Revocation checker is not able to check this Certificate subclass: " + cert.getClass().getName());
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        RevocationChecker checker = GlobalRegistry.getService(RevocationChecker.class);
        try {
            checker.check(x509Cert, this.prevCert);
        }
        catch (RevokedCertException e) {
            throw new CertPathValidatorException("Certificate revocation check failed [" + x509Cert.getSubjectDN() + "]", e);
        }
        finally {
            this.prevCert = x509Cert;
        }
    }
}

