/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.crypto.SetServerNameSocketFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class PFSSLContextWrapper
extends SSLContextSpi {
    private final SSLContext delegate;

    public PFSSLContextWrapper() {
        this("TLS");
    }

    public PFSSLContextWrapper(String protocol) {
        try {
            this.delegate = SSLContext.getInstance(protocol, SecurityProviderUtil.getSunJSSEProviderOrEquivalent());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new ProcessRuntimeException("Could not retrieve SSLContext instance for protocol " + protocol, e);
        }
    }

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        this.delegate.init(keyManagers, trustManagers, secureRandom);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        SSLSocketFactory delegateFactory = this.delegate.getSocketFactory();
        return new SetServerNameSocketFactory(delegateFactory);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.delegate.getServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.delegate.createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String peerHost, int peerPort) {
        return this.delegate.createSSLEngine(peerHost, peerPort);
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.delegate.getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.delegate.getClientSessionContext();
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        return this.delegate.getDefaultSSLParameters();
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        return this.delegate.getSupportedSSLParameters();
    }
}

