/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.PFRevocationChecker;
import com.pingidentity.crypto.SecurityProviderUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class PKIXTrustManagerFactoryWrapper
extends TrustManagerFactorySpi {
    private static final Log log = LogFactory.getLog((String)PKIXTrustManagerFactoryWrapper.class.getName());
    private final TrustManagerFactory delegate;
    private final TrustedCAsManager trustedCAsManager = MgmtFactory.getTrustedCAsManager();

    public PKIXTrustManagerFactoryWrapper() {
        try {
            this.delegate = TrustManagerFactory.getInstance("PKIX", SecurityProviderUtil.getSunJSSEProviderOrEquivalent());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            log.debug((Object)"Could not retrieve PKIX TrustManagerFactory", (Throwable)e);
            throw new ProcessRuntimeException("Could not retrieve PKIX TrustManagerFactory", e);
        }
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        try {
            PKIXParameters params;
            if (keyStore == null) {
                Set<TrustAnchor> trustAnchors = this.trustedCAsManager.getAllTrustAnchors();
                params = new PKIXParameters(trustAnchors);
            } else {
                params = new PKIXParameters(keyStore);
            }
            params = PFRevocationChecker.addCheckerToParams(params);
            this.delegate.init(new CertPathTrustManagerParameters(params));
        }
        catch (InvalidAlgorithmParameterException e) {
            log.debug((Object)"Could not initialize PKIX TrustManagerFactory", (Throwable)e);
            throw new ProcessRuntimeException("Could not initialize PKIX TrustManagerFactory", e);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof CertPathTrustManagerParameters) {
            CertPathTrustManagerParameters params = (CertPathTrustManagerParameters)managerFactoryParameters;
            PKIXParameters pkixParameters = (PKIXParameters)params.getParameters();
            pkixParameters = PFRevocationChecker.addCheckerToParams(pkixParameters);
            this.delegate.init(new CertPathTrustManagerParameters(pkixParameters));
        } else {
            this.delegate.init(managerFactoryParameters);
        }
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return this.delegate.getTrustManagers();
    }
}

