/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.crypto.PasswordFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PasswordFile {
    public static final String HSM_FILENAME = "hsmpasswd.txt";
    public static final String HSM_USERNAME = "HSM";
    private static final String LINE_ENDING = System.getProperty("line.separator");
    public static final int USERNAME_FIELD = 0;
    public static final int OBSFUCATED_PASSWORD = 1;

    private static String localObfuscate(String inStr) {
        return Obfuscator.obfuscate(inStr);
    }

    private static String localDeobfuscate(String inStr) {
        String clearText = Obfuscator.deobfuscate(inStr);
        return clearText;
    }

    public static Map<String, ObfuscatedPassword> readPasswords(File passwordFile) {
        HashMap<String, ObfuscatedPassword> passwords = new HashMap<String, ObfuscatedPassword>();
        if (!passwordFile.exists()) {
            return passwords;
        }
        try (LineNumberReader r = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(passwordFile), StandardCharsets.UTF_8));){
            String line = r.readLine();
            while (line != null) {
                String[] fields = line.split(":");
                if (fields.length == 2) {
                    passwords.put(fields[0], new ObfuscatedPassword(fields[1]));
                }
                line = r.readLine();
            }
        }
        catch (IOException e) {
            throw new PasswordFileException("Error occurred processing the password file: " + passwordFile, e);
        }
        return passwords;
    }

    private static void writePasswords(File passwordFile, Map<String, ObfuscatedPassword> passwords) {
        Date now = new Date();
        File tempPwdFile = new File(passwordFile.getParentFile(), "TMP" + now.getTime());
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(tempPwdFile), StandardCharsets.UTF_8);){
            ArrayList<String> users = new ArrayList<String>(passwords.keySet());
            Collections.sort(users);
            for (String user : users) {
                ObfuscatedPassword e = passwords.get(user);
                w.write(user + ":" + e.obsPassword);
                w.write(LINE_ENDING);
            }
            ((Writer)w).flush();
        }
        catch (IOException e) {
            String unableToWritePwdErrMsg = "Unable to write password data to file: " + passwordFile;
            boolean deleted = tempPwdFile.delete();
            if (!deleted) {
                String additionalError = unableToWritePwdErrMsg + "; Unable to delete the temporary password file: " + tempPwdFile;
                throw new PasswordFileException(additionalError, e);
            }
            throw new PasswordFileException(unableToWritePwdErrMsg, e);
        }
        boolean fileExisted = passwordFile.delete();
        boolean renamed = tempPwdFile.renameTo(passwordFile);
        if (renamed) {
            System.out.println("File " + passwordFile.getName() + " has been " + (fileExisted ? "updated" : "created") + ".");
        }
    }

    public static void obfuscatePassword(File passwordFile, String username, String password) {
        Map<String, ObfuscatedPassword> passwords = PasswordFile.readPasswords(passwordFile);
        passwords.put(username, ObfuscatedPassword.obfuscatePassword(password));
        PasswordFile.writePasswords(passwordFile, passwords);
    }

    public static String getAndDeobfuscateHSMPassword(String dataDir) {
        File passwordFile = PasswordFile.getHSMPasswordFile(dataDir);
        return PasswordFile.getAndDeobfuscateHSMPassword(passwordFile);
    }

    public static String getObfuscatedHSMPassword(File passwordFile) {
        ObfuscatedPassword pe = PasswordFile.getObfuscatedPassword(passwordFile);
        return pe.getObfuscatedPassword();
    }

    public static String getAndDeobfuscateHSMPassword(File passwordFile) {
        ObfuscatedPassword pe = PasswordFile.getObfuscatedPassword(passwordFile);
        return pe.getPassword();
    }

    private static ObfuscatedPassword getObfuscatedPassword(File passwordFile) {
        Map<String, ObfuscatedPassword> passwords = PasswordFile.readPasswords(passwordFile);
        ObfuscatedPassword pe = passwords.get(HSM_USERNAME);
        if (pe == null) {
            throw new PasswordFileException("no password for HSM in file " + passwordFile.getAbsolutePath());
        }
        return pe;
    }

    private static File getHSMPasswordFile(String dataDir) {
        String dataFile = dataDir + File.separatorChar + HSM_FILENAME;
        File f = new File(dataFile);
        if (!f.exists() || !f.isFile()) {
            throw new PasswordFileException("Can't access HSM Password file: " + f.getAbsolutePath());
        }
        return f;
    }

    public static class ObfuscatedPassword {
        public final String obsPassword;

        public ObfuscatedPassword(String password) {
            this.obsPassword = password;
        }

        public static ObfuscatedPassword obfuscatePassword(String password) {
            return new ObfuscatedPassword(PasswordFile.localObfuscate(password));
        }

        public String getPassword() {
            return PasswordFile.localDeobfuscate(this.obsPassword);
        }

        public String getObfuscatedPassword() {
            return this.obsPassword;
        }
    }
}

