/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.CRLDistributionPointExtensionRevocationChecker;
import com.pingidentity.crypto.OCSPChecker;
import com.pingidentity.crypto.OCSPCheckerImpl;
import com.pingidentity.crypto.OCSPFailoverToCRLException;
import com.pingidentity.crypto.RevokedCertException;
import java.security.cert.X509Certificate;

public class RevocationCheckerImpl
extends CRLDistributionPointExtensionRevocationChecker {
    private volatile OCSPChecker ocspChecker = null;

    @Override
    public void check(X509Certificate[] chain) throws RevokedCertException {
        if (chain == null) {
            return;
        }
        for (int idx = 0; idx < chain.length; ++idx) {
            X509Certificate x509Certificate = chain[idx];
            int next = idx + 1;
            X509Certificate issuer = chain.length > next ? chain[next] : null;
            this.check(x509Certificate, issuer);
        }
    }

    @Override
    public void check(X509Certificate cert, X509Certificate issuer) throws RevokedCertException {
        boolean ocspEnabled = this.config.getBooleanValue("OCSP-enable", false);
        boolean crlEnabled = this.config.getBooleanValue("crl-enable", true);
        if (ocspEnabled) {
            if (this.ocspChecker == null) {
                this.ocspChecker = new OCSPCheckerImpl(this.config);
            }
            try {
                this.ocspChecker.check(cert, issuer);
            }
            catch (OCSPFailoverToCRLException e) {
                if (crlEnabled) {
                    super.check(cert, issuer);
                }
            }
        } else if (crlEnabled) {
            super.check(cert, issuer);
        }
    }
}

