/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.util.IPAddress;

public class SetServerNameSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegateSocketFactory;

    public SetServerNameSocketFactory(SSLSocketFactory delegateSocketFactory) {
        this.delegateSocketFactory = delegateSocketFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegateSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegateSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.setSSLParameters(this.delegateSocketFactory.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.setSSLParameters(this.delegateSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress inetAddress, int localPort) throws IOException {
        return this.setSSLParameters(this.delegateSocketFactory.createSocket(host, port, inetAddress, localPort));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        return this.setSSLParameters(this.delegateSocketFactory.createSocket(inetAddress, port));
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localhost, int localPort) throws IOException {
        return this.setSSLParameters(this.delegateSocketFactory.createSocket(host, port, localhost, localPort));
    }

    private Socket setSSLParameters(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLParameters sslParameters = ((SSLSocket)socket).getSSLParameters();
            SNIHostName sniHostName = this.getSNIHostName(socket);
            if (sniHostName != null) {
                List<SNIServerName> serverNames = sslParameters.getServerNames();
                if (serverNames != null) {
                    if (!serverNames.contains(sniHostName)) {
                        ArrayList<SNIServerName> newServerNames = new ArrayList<SNIServerName>(serverNames);
                        newServerNames.add(sniHostName);
                        sslParameters.setServerNames(newServerNames);
                    }
                } else {
                    sslParameters.setServerNames(Collections.singletonList(sniHostName));
                }
            }
        }
        return socket;
    }

    private SNIHostName getSNIHostName(Socket socket) {
        String host;
        if (socket.getInetAddress() != null && null != (host = socket.getInetAddress().getHostName()) && host.indexOf(46) > 0 && !IPAddress.isValid((String)host)) {
            return new SNIHostName(host);
        }
        return null;
    }
}

