/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.SignatureAlgorithms;
import java.util.Comparator;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;

public class SignatureAlgorithm {
    private String name;
    private String uri;
    private static final boolean IS_RSA_PSS_AVAILABLE;
    public static final Comparator<SignatureAlgorithm> ALPHABETICAL;
    public static final Comparator<SignatureAlgorithm> ALPHABETICAL_HANDLE_UNDERSCORE;

    public SignatureAlgorithm(String name, String uri) {
        this.name = name;
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getNameForRuntime() {
        return SignatureAlgorithms.getInstance().algUriToNameForRuntime(this.uri);
    }

    public static boolean isRSAPSSAvailable() {
        return IS_RSA_PSS_AVAILABLE;
    }

    static {
        AlgorithmFactory algs = AlgorithmFactoryFactory.getInstance().getJwsAlgorithmFactory();
        IS_RSA_PSS_AVAILABLE = algs.isAvailable("PS256") && algs.isAvailable("PS384") && algs.isAvailable("PS512");
        ALPHABETICAL = new Comparator<SignatureAlgorithm>(){

            @Override
            public int compare(SignatureAlgorithm alg1, SignatureAlgorithm alg2) {
                return alg1.getName().compareTo(alg2.getName());
            }
        };
        ALPHABETICAL_HANDLE_UNDERSCORE = new Comparator<SignatureAlgorithm>(){

            @Override
            public int compare(SignatureAlgorithm alg1, SignatureAlgorithm alg2) {
                String[] algWords1 = alg1.getName().split("_");
                String[] algWords2 = alg2.getName().split("_");
                int shortest = Math.min(algWords1.length, algWords2.length);
                for (int wordsIdx = 0; wordsIdx < shortest; ++wordsIdx) {
                    int result = algWords1[wordsIdx].compareTo(algWords2[wordsIdx]);
                    if (result == 0) continue;
                    return result;
                }
                return Integer.compare(algWords1.length, algWords2.length);
            }
        };
    }
}

