/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.crypto.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;

public class SignatureAlgorithms {
    private static final String SIGNATURE_MAP_NAME = "signature-algorithms";
    private static final String SIGNATURE_RUNTIME_MAP_NAME = "signature-algorithms-runtime";
    private static final String DIGEST_MAP_NAME = "digest-algorithms";
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig(SignatureAlgorithms.class);
    private static final Log log = LogFactory.getLog(SignatureAlgorithms.class);
    private static final Map<String, String> defaultSignatureAlgorithmsRuntimeMap = new HashMap<String, String>();
    private static final Map<String, String> javaAlgNameToJwaAlgIdMap = new HashMap<String, String>();
    private static final Map<String, String> ecCurveNameToSignatureAlgMap = new HashMap<String, String>();
    public static final String RSA_SHA256_MGF1_URI = "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1";
    public static final String RSA_SHA384_MGF1_URI = "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1";
    public static final String RSA_SHA512_MGF1_URI = "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1";
    public static final List<String> RSASSA_PSS_ALGORITHM_URI_LIST = Collections.unmodifiableList(Arrays.asList("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1"));
    public static final String RSA_SHA256_MGF1_ID = "SHA256withRSAandMGF1";
    public static final String RSA_SHA384_MGF1_ID = "SHA384withRSAandMGF1";
    public static final String RSA_SHA512_MGF1_ID = "SHA512withRSAandMGF1";
    public static final List<String> RSASSA_PSS_ALGORITHM_ID_LIST = Collections.unmodifiableList(Arrays.asList("SHA256withRSAandMGF1", "SHA384withRSAandMGF1", "SHA512withRSAandMGF1"));
    private static final String AND_MGF_1 = "andMGF1";
    private static SignatureAlgorithms instance;
    private List<SignatureAlgorithm> sigAlgList = new ArrayList<SignatureAlgorithm>();
    private Map<String, String> digestMap = new HashMap<String, String>();
    private Map<String, String> sigUriToDigestMap = new HashMap<String, String>();
    private Map<String, String> sigUriToNameMap = new HashMap<String, String>();
    private Map<String, String> sigNameToUriMap = new HashMap<String, String>();
    private Map<String, String> sigUriToNameMapForRuntime = new HashMap<String, String>();
    private Map<String, String> sigNameToUriMapForRuntime = new HashMap<String, String>();
    public static final String RSA = "RSA";
    public static final String DSA = "DSA";
    public static final String EC = "EC";
    public static final String RSA_SHA1 = "RSA_SHA1";
    public static final String RSA_SHA256 = "RSA_SHA256";
    public static final String RSA_SHA384 = "RSA_SHA384";
    public static final String RSA_SHA512 = "RSA_SHA512";
    public static final String DSA_SHA1 = "DSA_SHA1";
    public static final String ECDSA_SHA256 = "ECDSA_SHA256";
    public static final String ECDSA_SHA384 = "ECDSA_SHA384";
    public static final String ECDSA_SHA512 = "ECDSA_SHA512";

    private SignatureAlgorithms() {
        this.sigAlgList = new ArrayList<SignatureAlgorithm>();
        this.sigUriToNameMap = new HashMap<String, String>();
        this.sigNameToUriMap = new HashMap<String, String>();
        try {
            Map algorithms = configStore.getMapValue(SIGNATURE_MAP_NAME);
            if (algorithms != null && !algorithms.isEmpty()) {
                algorithms.forEach((name, uri) -> {
                    this.sigAlgList.add(new SignatureAlgorithm((String)name, (String)uri));
                    this.sigUriToNameMap.put((String)uri, (String)name);
                    this.sigNameToUriMap.put((String)name, (String)uri);
                });
            }
            this.digestMap = configStore.getMapValue(DIGEST_MAP_NAME);
        }
        catch (NoSuchValueException e) {
            log.info((Object)"signature-algorithms or digest-algorithms is not defined");
            this.sigAlgList = new ArrayList<SignatureAlgorithm>();
            this.sigAlgList.add(new SignatureAlgorithm(RSA_SHA1, "http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
            this.sigAlgList.add(new SignatureAlgorithm(DSA_SHA1, "http://www.w3.org/2000/09/xmldsig#dsa-sha1"));
            this.sigAlgList.add(new SignatureAlgorithm(ECDSA_SHA256, "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
            this.digestMap = new HashMap<String, String>();
            this.digestMap.put(RSA_SHA1, "http://www.w3.org/2000/09/xmldsig#sha1");
            this.digestMap.put(DSA_SHA1, "http://www.w3.org/2000/09/xmldsig#sha1");
            this.digestMap.put(ECDSA_SHA256, "http://www.w3.org/2001/04/xmlenc#sha256");
        }
        for (SignatureAlgorithm sigAlg : this.sigAlgList) {
            this.sigUriToDigestMap.put(sigAlg.getUri(), this.digestMap.get(sigAlg.getName()));
        }
        Map algorithmsForRuntime = configStore.getMapValue(SIGNATURE_RUNTIME_MAP_NAME, this.getDefaultSignatureAlgorithmsRuntime());
        if (algorithmsForRuntime != null && !algorithmsForRuntime.isEmpty()) {
            algorithmsForRuntime.forEach((name, uri) -> {
                this.sigUriToNameMapForRuntime.put((String)uri, (String)name);
                this.sigNameToUriMapForRuntime.put((String)name, (String)uri);
            });
        }
    }

    public static SignatureAlgorithms getInstance() {
        return instance;
    }

    public List<SignatureAlgorithm> getSupportedSignatureAlgorithms() {
        return this.sigAlgList;
    }

    public List<SignatureAlgorithm> getSupportedSignatureAlgorithms(String keyAlgorithm) {
        return this.getSortedSignatureAlgorithmsOfType(keyAlgorithm);
    }

    public boolean isSignatureAlgorithmSupported(String keyAlgorithm) {
        for (SignatureAlgorithm alg : this.getSupportedSignatureAlgorithms()) {
            if (!alg.getName().startsWith(keyAlgorithm)) continue;
            return true;
        }
        return false;
    }

    private List<SignatureAlgorithm> getSortedSignatureAlgorithmsOfType(String prefix) {
        ArrayList<SignatureAlgorithm> rsaAlgs = new ArrayList<SignatureAlgorithm>();
        for (SignatureAlgorithm alg : this.getSupportedSignatureAlgorithms()) {
            if (!alg.getName().startsWith(prefix)) continue;
            rsaAlgs.add(alg);
        }
        Collections.sort(rsaAlgs, SignatureAlgorithm.ALPHABETICAL_HANDLE_UNDERSCORE);
        return rsaAlgs;
    }

    private Map<String, String> getDefaultSignatureAlgorithmsRuntime() {
        return defaultSignatureAlgorithmsRuntimeMap;
    }

    public String getDigestUri(String algUri) {
        return this.sigUriToDigestMap.get(algUri);
    }

    public String algUriToName(String algUri) {
        return this.sigUriToNameMap.get(algUri);
    }

    public String algNameToUri(String algName) {
        return this.sigNameToUriMap.get(algName);
    }

    public String algUriToNameForRuntime(String algUri) {
        return this.sigUriToNameMapForRuntime.get(algUri);
    }

    public String algNameToUriForRuntime(String algName) {
        return this.sigNameToUriMapForRuntime.get(algName);
    }

    public Collection<String> getJwaAlgorithmIds() {
        return javaAlgNameToJwaAlgIdMap.values();
    }

    public String algUriToJwaAlgorithmId(String algUri) {
        String javaAlgName = this.sigUriToNameMapForRuntime.get(algUri);
        if (javaAlgName == null) {
            return null;
        }
        return javaAlgNameToJwaAlgIdMap.get(javaAlgName);
    }

    public SignatureAlgorithm getDefaultSignatureAlgorithmOfType(String algorithmType) {
        String defaultAlgorithm = null;
        if (DSA.equals(algorithmType)) {
            defaultAlgorithm = DSA_SHA1;
        } else if (RSA.equals(algorithmType)) {
            defaultAlgorithm = RSA_SHA256;
        } else if (EC.equals(algorithmType)) {
            defaultAlgorithm = ECDSA_SHA256;
        }
        if (defaultAlgorithm != null) {
            for (SignatureAlgorithm algorithm : this.getSupportedSignatureAlgorithms()) {
                if (!algorithm.getName().equals(defaultAlgorithm)) continue;
                return algorithm;
            }
        }
        return null;
    }

    public String getEcSignatureAlgorithmName(String curveName) {
        return ecCurveNameToSignatureAlgMap.get(curveName);
    }

    static {
        defaultSignatureAlgorithmsRuntimeMap.put("SHA1withDSA", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        defaultSignatureAlgorithmsRuntimeMap.put("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        defaultSignatureAlgorithmsRuntimeMap.put("SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        defaultSignatureAlgorithmsRuntimeMap.put("SHA384withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
        defaultSignatureAlgorithmsRuntimeMap.put("SHA512withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        defaultSignatureAlgorithmsRuntimeMap.put(RSA_SHA256_MGF1_ID, RSA_SHA256_MGF1_URI);
        defaultSignatureAlgorithmsRuntimeMap.put(RSA_SHA384_MGF1_ID, RSA_SHA384_MGF1_URI);
        defaultSignatureAlgorithmsRuntimeMap.put(RSA_SHA512_MGF1_ID, RSA_SHA512_MGF1_URI);
        defaultSignatureAlgorithmsRuntimeMap.put("SHA256withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
        defaultSignatureAlgorithmsRuntimeMap.put("SHA384withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384");
        defaultSignatureAlgorithmsRuntimeMap.put("SHA512withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
        javaAlgNameToJwaAlgIdMap.put("SHA256withRSA", "RS256");
        javaAlgNameToJwaAlgIdMap.put("SHA384withRSA", "RS384");
        javaAlgNameToJwaAlgIdMap.put("SHA512withRSA", "RS512");
        javaAlgNameToJwaAlgIdMap.put(RSA_SHA256_MGF1_ID, "PS256");
        javaAlgNameToJwaAlgIdMap.put(RSA_SHA384_MGF1_ID, "PS384");
        javaAlgNameToJwaAlgIdMap.put(RSA_SHA512_MGF1_ID, "PS512");
        javaAlgNameToJwaAlgIdMap.put("SHA256withECDSA", "ES256");
        javaAlgNameToJwaAlgIdMap.put("SHA384withECDSA", "ES384");
        javaAlgNameToJwaAlgIdMap.put("SHA512withECDSA", "ES512");
        ecCurveNameToSignatureAlgMap.put("P-256", "ES256");
        ecCurveNameToSignatureAlgMap.put("P-384", "ES384");
        ecCurveNameToSignatureAlgMap.put("P-521", "ES512");
        ecCurveNameToSignatureAlgMap.put("secp256k1", "ES256K");
        instance = new SignatureAlgorithms();
    }
}

