/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.pingcommons.crypto.CertificateUtil;
import java.security.cert.CertPathValidatorException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class X509CertPathValidatorSupport {
    private static final Log log = LogFactory.getLog(X509CertPathValidatorSupport.class);
    private List<X509Certificate> chain;
    private Set<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
    private Boolean isPathValid;

    public X509CertPathValidatorSupport(X509Certificate[] certs) {
        this(certs, true);
    }

    public X509CertPathValidatorSupport(X509Certificate[] certs, boolean pruneChainBasedOnAllTrustAnchors) {
        this.chain = pruneChainBasedOnAllTrustAnchors ? X509CertPathValidatorSupport.makeCertList(certs, null) : Arrays.asList(certs);
    }

    private static List<X509Certificate> makeCertList(X509Certificate[] certs, Collection<X509Certificate> trustedCerts) {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = certs[i];
            if (i > 0 && (cert.getIssuerDN().equals(cert.getSubjectDN()) || trustedCerts != null && trustedCerts.contains(cert) || trustedCerts == null && MgmtFactory.getTrustedCAsManager().isInAllTrustAnchors(cert))) break;
            certList.add(cert);
        }
        return certList;
    }

    public void addTrustAnchor(TrustAnchor anchor) {
        this.isPathValid = null;
        this.trustAnchors.add(anchor);
    }

    public void addTrustAnchors(Set<TrustAnchor> trustAnchors) {
        this.isPathValid = null;
        this.trustAnchors.addAll(trustAnchors);
    }

    public void addTrustAnchors(Collection<X509Certificate> anchors) {
        this.isPathValid = null;
        for (X509Certificate cert : anchors) {
            this.trustAnchors.add(new TrustAnchor(cert, null));
        }
    }

    public void validate() throws CertPathValidatorException {
        CertificateUtil.validateCertPathAgainstTrustAnchors(this.chain, this.trustAnchors);
    }

    public static boolean isValid(List<X509Certificate> chain, Set<TrustAnchor> trustAnchors) {
        try {
            CertificateUtil.validateCertPathAgainstTrustAnchors(chain, trustAnchors);
            return true;
        }
        catch (CertPathValidatorException certPathValidatorException) {
            return false;
        }
    }

    public void pruneCertChain() {
        this.chain = X509CertPathValidatorSupport.makeCertList(this.chain.toArray(new X509Certificate[0]), this.unwrapTrustAnchors());
        this.isPathValid = null;
    }

    private List<X509Certificate> unwrapTrustAnchors() {
        ArrayList<X509Certificate> anchorsAsCerts = new ArrayList<X509Certificate>();
        for (TrustAnchor anchor : this.trustAnchors) {
            anchorsAsCerts.add(anchor.getTrustedCert());
        }
        return anchorsAsCerts;
    }

    public boolean isPathValid() {
        if (this.isPathValid == null) {
            try {
                this.validate();
                this.isPathValid = true;
            }
            catch (CertPathValidatorException e) {
                log.info((Object)(this.chain + " PKIX validation unsuccessful: " + e));
                this.isPathValid = false;
            }
        }
        return this.isPathValid;
    }
}

