/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import com.pingidentity.common.util.B64;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class X509CertificateUtils {
    private static final Log log = LogFactory.getLog(X509CertificateUtils.class);
    private static final int SEARCH_DEPTH = 10;

    private X509CertificateUtils() {
    }

    public static X509Certificate toCertificate(String cert) throws CertificateException {
        if (StringUtils.isBlank((String)cert)) {
            throw new CertificateException("cert cannot be null");
        }
        String sanitizedCert = cert.trim();
        if (sanitizedCert.startsWith("-----BEGIN CERTIFICATE-----")) {
            sanitizedCert = sanitizedCert.substring("-----BEGIN CERTIFICATE-----".length() + 1);
        }
        if (sanitizedCert.endsWith("-----END CERTIFICATE-----")) {
            sanitizedCert = sanitizedCert.substring(0, sanitizedCert.length() - "-----END CERTIFICATE-----".length());
        }
        byte[] buf = B64.decodeToBytes((String)sanitizedCert);
        ByteArrayInputStream inStream = new ByteArrayInputStream(buf);
        CertificateFactory instance = CertificateFactory.getInstance("X.509");
        return (X509Certificate)instance.generateCertificate(inStream);
    }

    public static X509Certificate[] getCertFromSSLHeaders(HttpServletRequest request, String clientCertHeader, String clientCertChainHeader) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (StringUtils.isBlank((String)clientCertHeader)) {
            return null;
        }
        X509Certificate clientCert = X509CertificateUtils.getCertFromSSLHeader(request, clientCertHeader);
        if (clientCert != null) {
            certs.add(clientCert);
            if (StringUtils.isNotBlank((String)clientCertChainHeader)) {
                String clientCertChainHeaderIndex;
                X509Certificate clientCertChainPart;
                for (int i = 0; i < 10 && (clientCertChainPart = X509CertificateUtils.getCertFromSSLHeader(request, clientCertChainHeaderIndex = clientCertChainHeader + i)) != null; ++i) {
                    certs.add(clientCertChainPart);
                }
            }
        }
        if (certs.isEmpty()) {
            return null;
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public static X509Certificate getCertFromSSLHeader(HttpServletRequest request, String clientCertHeader) {
        String clientCert = request.getHeader(clientCertHeader);
        if (StringUtils.isBlank((String)clientCert) || "(null)".equals(clientCert)) {
            return null;
        }
        try {
            return X509CertificateUtils.toCertificate(clientCert);
        }
        catch (CertificateException e) {
            log.warn((Object)("There is an error when parsing the client cert for request header: " + clientCertHeader), (Throwable)e);
            return null;
        }
    }
}

