/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.expiry.notification.impl;

import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.CertificateReferenceType;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.crypto.expiry.notification.CertificateExpiryNotification;
import com.pingidentity.crypto.expiry.notification.CertificateExpiryNotificationManager;
import comPfCertExpiryNotification.pingidentity.CertificateExpiryNotificationType;
import comPfCertExpiryNotification.pingidentity.CertificateExpiryNotificationsDocument;
import comPfCertExpiryNotification.pingidentity.CertificateExpiryNotificationsType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CertificateExpiryNotificationManagerImpl
implements CertificateExpiryNotificationManager {
    private static final Log log = LogFactory.getLog((String)"com.pingidentity.crypto.expiry.notification.impl.CertificateExpiryNotificationManagerImpl");
    private static final String XML_FILE_NAME = "pf-certificate-expiry-console-warnings.xml";
    private final XmlLoader xmlLoader;
    private final String directory;
    private final Collection<CertificateExpiryNotification> notifications = new ArrayList<CertificateExpiryNotification>();

    public CertificateExpiryNotificationManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this.xmlLoader = xmlLoader;
        this.directory = sysDirInfo.getInstanceDataDirectory();
        if (MgmtFactory.getMediator().isConsole()) {
            this.loadConfig();
        }
    }

    @Override
    public synchronized Collection<CertificateExpiryNotification> getCertificateExpiryEntries() {
        return Collections.unmodifiableCollection(this.notifications);
    }

    @Override
    public synchronized boolean certificateExpiryNotificationExist() {
        return !this.notifications.isEmpty();
    }

    @Override
    public synchronized void saveCertificateExpiryNotificationEntries(Collection<CertificateExpiryNotification> certificateExpiryNotifications) {
        this.notifications.clear();
        this.notifications.addAll(certificateExpiryNotifications);
        this.saveConfig();
    }

    @Override
    public synchronized void clearExpiryNotifications() {
        if (!this.notifications.isEmpty()) {
            this.notifications.clear();
            this.saveConfig();
        }
    }

    private synchronized void loadConfig() {
        CertificateExpiryNotificationsDocument doc;
        this.notifications.clear();
        if (this.xmlLoader.xmlExists(this.directory, XML_FILE_NAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, XML_FILE_NAME);
            doc = (CertificateExpiryNotificationsDocument)xmlObject;
        } else {
            doc = CertificateExpiryNotificationsDocument.Factory.newInstance();
            doc.addNewCertificateExpiryNotifications();
        }
        CertificateExpiryNotificationsType notificationsType = doc.getCertificateExpiryNotifications();
        for (CertificateExpiryNotificationType notificationType : notificationsType.getCertificateExpiryNotificationTypeArray()) {
            CertificateExpiryNotification notification = new CertificateExpiryNotification(notificationType.getId(), CertificateType.valueOf(notificationType.getType()));
            notification.setReferenceItemId(notificationType.getReferenceId());
            if (notificationType.getReferenceType() != null) {
                notification.setReferenceItemType(CertificateReferenceType.valueOf(notificationType.getReferenceType()));
            }
            this.notifications.add(notification);
        }
    }

    private synchronized void saveConfig() {
        CertificateExpiryNotificationsDocument doc = CertificateExpiryNotificationsDocument.Factory.newInstance();
        CertificateExpiryNotificationsType notificationsType = doc.addNewCertificateExpiryNotifications();
        for (CertificateExpiryNotification notification : this.notifications) {
            CertificateExpiryNotificationType notificationType = notificationsType.addNewCertificateExpiryNotificationType();
            notificationType.setId(notification.getCertificateId());
            notificationType.setType(notification.getCertificateType().toString());
            notificationType.setReferenceId(notification.getReferenceItemId());
            if (notification.getReferenceItemType() == null) continue;
            notificationType.setReferenceType(notification.getReferenceItemType().toString());
        }
        this.xmlLoader.save(this.directory, XML_FILE_NAME, (XmlObject)doc);
        this.loadConfig();
    }
}

