/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.DynamicKeyMaker;
import com.pingidentity.crypto.jwk.JsonWebKeysAdder;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import com.pingidentity.crypto.jwk.JwkState;
import com.pingidentity.crypto.jwk.JwkWrapper;
import com.pingidentity.crypto.jwk.JwksContent;
import com.pingidentity.crypto.jwk.KeyMaker;
import com.pingidentity.crypto.jwk.SavedKeyMaker;
import com.pingidentity.jgroups.JGUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.util.RspList;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.QuietRpc;

public class GroupRpcJsonWebKeysAdder
extends BaseGroupRpc
implements JsonWebKeysAdder {
    private static final String CFG_SYNCHRONIZE_KEYS_INTERVAL_SECS = "SynchronizeKeysIntervalSecs";
    private static final String CFG_SYNCHRONIZE_KEYS_TIMEOUT_MILLIS = "SynchronizeKeysTimeoutMillis";
    private static final String ADD_KEYS_METHOD_NAME = "addKeys";
    private static final Class[] ADD_KEYS_METHOD_SIG = new Class[]{JwksContent.class};
    private static final String SYNCHRONIZE_KEYS_METHOD_NAME = "synchronizeKeys";
    private static final Class[] SYNCHRONIZE_KEYS_METHOD_SIG = new Class[]{List.class};
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.crypto.jwk.GroupRpcJsonWebKeysAdder");
    private JwkState jwkState = (JwkState)this.muxRpcDispatcherMgr.getRpcInvocationTarget(JwksRpcTarget.class);
    private volatile boolean addKeysInvoked = false;

    public GroupRpcJsonWebKeysAdder() {
        int broadcastKeysIntervalSecs = this.configStore.getIntValue(CFG_SYNCHRONIZE_KEYS_INTERVAL_SECS, 60);
        MgmtFactory.getSingleThreadedExecutor().scheduleWithFixedDelay(new SynchronizeKeysTask(), broadcastKeysIntervalSecs, broadcastKeysIntervalSecs, TimeUnit.SECONDS);
    }

    @Override
    public void addKeys(KeyMaker maker) {
        this.addKeysInvoked = true;
        JChannel channel = this.rpcDispatcher.getChannel();
        if (JGUtil.isLead(channel)) {
            this.log.debug((Object)"Creating and distributing new keys");
            Object[] args = new Object[]{maker.makeKeys()};
            this.callRemoteMethods(ADD_KEYS_METHOD_NAME, ADD_KEYS_METHOD_SIG, true, 20000, args);
        } else {
            this.log.debug((Object)"Key rotation interval hit but I'm not the lead node so I defer to the lead to create and distribute new keys");
        }
    }

    @Override
    public JwkState getJwkState() {
        return this.jwkState;
    }

    public static interface JwksRpcTarget {
        public void addKeys(JwksContent var1);

        @QuietRpc
        public List<JwkWrapper> synchronizeKeys(List<JwkWrapper> var1);
    }

    private class SynchronizeKeysTask
    implements Runnable {
        private final Log log = LogFactory.getLog(SynchronizeKeysTask.class);

        private SynchronizeKeysTask() {
        }

        @Override
        public void run() {
            try {
                boolean broadcastKeys;
                boolean isCoord = false;
                Address coord = GroupRpcJsonWebKeysAdder.this.getCoord();
                if (coord != null && coord.equals(GroupRpcJsonWebKeysAdder.this.getLocalAddress())) {
                    isCoord = true;
                }
                boolean hasActiveKeys = GroupRpcJsonWebKeysAdder.this.jwkState.getKeys().stream().anyMatch(key -> key.getLifecycleState() == JwkLifecycleState.ACTIVE);
                boolean generateKeys = GroupRpcJsonWebKeysAdder.this.addKeysInvoked && isCoord && !hasActiveKeys;
                boolean bl = broadcastKeys = GroupRpcJsonWebKeysAdder.this.addKeysInvoked && isCoord;
                if (generateKeys) {
                    JwkFacilitator jwkFacilitator = GlobalRegistry.getService(JwkFacilitator.class);
                    this.log.debug((Object)"This node is now the coordinator but does not have any active JWKS keys, adding keys now");
                    DynamicKeyMaker keyMaker = jwkFacilitator.getDynamicKeyMaker();
                    SavedKeyMaker savedKeyMaker = jwkFacilitator.getSavedKeyMaker();
                    GroupRpcJsonWebKeysAdder.this.addKeys(savedKeyMaker);
                    GroupRpcJsonWebKeysAdder.this.addKeys(keyMaker);
                    GroupRpcJsonWebKeysAdder.this.addKeys(keyMaker);
                } else if (broadcastKeys) {
                    this.log.trace((Object)"Broadcasting current key set to cluster members");
                    Object[] args = new Object[]{GroupRpcJsonWebKeysAdder.this.jwkState.getAllKeys()};
                    RspList rsps = GroupRpcJsonWebKeysAdder.this.callRemoteMethods(null, GroupRpcJsonWebKeysAdder.SYNCHRONIZE_KEYS_METHOD_NAME, SYNCHRONIZE_KEYS_METHOD_SIG, true, GroupRpcJsonWebKeysAdder.this.configStore.getIntValue(GroupRpcJsonWebKeysAdder.CFG_SYNCHRONIZE_KEYS_TIMEOUT_MILLIS, 5000), BaseGroupRpc.LogLevel.TRACE, args);
                    List<JwkWrapper> wrappers = rsps.getResults().stream().flatMap(Collection::stream).collect(Collectors.toList());
                    if (!wrappers.isEmpty()) {
                        this.log.debug((Object)"Keys were found in the cluster that are not present (or are in an earlier lifecycle state) on this coordinator node, adding them now");
                        GroupRpcJsonWebKeysAdder.this.jwkState.registerKeys(wrappers);
                    }
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"Unexpected error while synchronizing keys", t);
            }
        }
    }
}

