/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.DirectJsonWebKeysAdder;
import com.pingidentity.crypto.jwk.GroupRpcJsonWebKeysAdder;
import com.pingidentity.crypto.jwk.JsonWebKeysAdder;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public final class JsonWebKeysAdderFactory {
    private JsonWebKeysAdder rpcJsonWebKeysAdder;
    private JsonWebKeysAdder staticDirectJsonWebKeysAdder;
    private JsonWebKeysAdder dynamicDirectJsonWebKeysAdder;
    private final Mediator mediator;

    JsonWebKeysAdderFactory() {
        this(MgmtFactory.getMediator());
    }

    JsonWebKeysAdderFactory(Mediator mediator) {
        this.mediator = mediator;
    }

    JsonWebKeysAdder getJwksAdder(Boolean usingStaticKeys) {
        if (usingStaticKeys != null && usingStaticKeys.booleanValue()) {
            return this.getStaticDirectImpl();
        }
        if (this.mediator.isDistributable()) {
            return this.getRpcImpl();
        }
        return this.getDynamicDirectImpl();
    }

    private synchronized JsonWebKeysAdder getRpcImpl() {
        if (this.rpcJsonWebKeysAdder == null) {
            this.rpcJsonWebKeysAdder = new GroupRpcJsonWebKeysAdder();
        }
        return this.rpcJsonWebKeysAdder;
    }

    private synchronized JsonWebKeysAdder getStaticDirectImpl() {
        if (this.staticDirectJsonWebKeysAdder == null) {
            this.staticDirectJsonWebKeysAdder = new DirectJsonWebKeysAdder();
        }
        return this.staticDirectJsonWebKeysAdder;
    }

    private synchronized JsonWebKeysAdder getDynamicDirectImpl() {
        if (this.dynamicDirectJsonWebKeysAdder == null) {
            this.dynamicDirectJsonWebKeysAdder = new DirectJsonWebKeysAdder();
        }
        return this.dynamicDirectJsonWebKeysAdder;
    }
}

