/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.IssuerSigningKeys;
import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import com.pingidentity.crypto.jwk.JwkUtils;
import com.pingidentity.crypto.jwk.JwkWrapper;
import com.pingidentity.crypto.jwk.JwksAdditionalKeysContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwkAdditionalKeysState {
    private static final Logger logger = LoggerFactory.getLogger(JwkAdditionalKeysState.class);
    private final ConcurrentMap<String, Map<String, JwkWrapper>> issuerToJwkWrappers = new ConcurrentHashMap<String, Map<String, JwkWrapper>>();

    JwkAdditionalKeysState(JwksAdditionalKeysContent additionalKeySet) {
        if (additionalKeySet == null || additionalKeySet.getKeySetIdsToSigningKeys() == null) {
            return;
        }
        for (String issuer : additionalKeySet.getIssuerToKeySetIds().keySet()) {
            LinkedHashMap keyWrapperForIssuer = new LinkedHashMap();
            Optional<IssuerSigningKeys> keySetByIssuer = additionalKeySet.getKeySetByIssuer(issuer);
            if (keySetByIssuer.isEmpty()) continue;
            IssuerSigningKeys issuerSigningKeys = keySetByIssuer.get();
            for (JwkKeyPair keyPair : issuerSigningKeys.getSigningKeys()) {
                boolean addDuplicateRS256Key = keyPair.getState() == JwkLifecycleState.ACTIVE ? issuerSigningKeys.isRequiresDuplicateActiveRsa256Jwk() : issuerSigningKeys.isRequiresDuplicatePreviousRsa256Jwk();
                JwkUtils.createJwkWrapper(keyPair, "sig").ifPresent(wrapper -> {
                    keyWrapperForIssuer.put(wrapper.getKeyId(), wrapper);
                    logger.info("Added new key to JSON Web Key Set: {}", (Object)wrapper.getJwk());
                });
                if (!addDuplicateRS256Key) continue;
                JwkUtils.createJwkWrapperForRS256SignatureAlgParam(keyPair, "sig").ifPresent(wrapper -> {
                    keyWrapperForIssuer.put(wrapper.getKeyId(), wrapper);
                    logger.info("Added duplicate RS256 key to JSON Web Key Set: {}", (Object)wrapper.getJwk());
                });
            }
            if (keyWrapperForIssuer.isEmpty()) continue;
            this.issuerToJwkWrappers.put(issuer, keyWrapperForIssuer);
        }
    }

    public List<JwkWrapper> getKeyPairsForIssuer(String issuer) {
        ArrayList<Object> keysForIssuer = new ArrayList();
        if (this.issuerToJwkWrappers.containsKey(issuer)) {
            keysForIssuer = new ArrayList(((Map)this.issuerToJwkWrappers.get(issuer)).values());
        }
        return Collections.unmodifiableList(keysForIssuer);
    }

    public void replaceAdditionalKeySetsWrapper(JwksAdditionalKeysContent newAdditionalKeySet) {
        this.issuerToJwkWrappers.clear();
        if (newAdditionalKeySet == null || newAdditionalKeySet.getIssuerToKeySetIds() == null || newAdditionalKeySet.getIssuerToKeySetIds().isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> keySet : newAdditionalKeySet.getIssuerToKeySetIds().entrySet()) {
            HashMap keysForIssuer = new HashMap();
            Optional<IssuerSigningKeys> keySetByIssuer = newAdditionalKeySet.getKeySetByIssuer(keySet.getKey());
            if (keySetByIssuer.isEmpty()) continue;
            IssuerSigningKeys issuerSigningKeys = keySetByIssuer.get();
            for (JwkKeyPair keyPair : issuerSigningKeys.getSigningKeys()) {
                boolean duplicateRsa256Key = keyPair.getState() == JwkLifecycleState.ACTIVE ? issuerSigningKeys.isRequiresDuplicateActiveRsa256Jwk() : issuerSigningKeys.isRequiresDuplicatePreviousRsa256Jwk();
                JwkUtils.createJwkWrapper(keyPair, "sig").ifPresent(wrapper -> {
                    keysForIssuer.put(keyPair.getKeyId(), wrapper);
                    logger.info("Added new key to JSON Web Key Set: {}", (Object)wrapper.getJwk());
                });
                if (!duplicateRsa256Key) continue;
                JwkUtils.createJwkWrapperForRS256SignatureAlgParam(keyPair, "sig").ifPresent(wrapper -> {
                    keysForIssuer.put(wrapper.getKeyId(), wrapper);
                    logger.info("Added duplicate RS256 key to JSON Web Key Set: {}", (Object)wrapper.getJwk());
                });
            }
            this.issuerToJwkWrappers.put(keySet.getKey(), keysForIssuer);
        }
    }

    public Map<String, Map<String, JwkWrapper>> getIssuerToJwkWrappers() {
        return Collections.unmodifiableMap(this.issuerToJwkWrappers);
    }
}

