/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.crypto.jwk.DynamicKeyMaker;
import com.pingidentity.crypto.jwk.JsonWebKeysAdder;
import com.pingidentity.crypto.jwk.JsonWebKeysAdderFactory;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import com.pingidentity.crypto.jwk.JwkState;
import com.pingidentity.crypto.jwk.JwkWrapper;
import com.pingidentity.crypto.jwk.SavedKeyMaker;
import com.pingidentity.crypto.jwk.StaticKeyMaker;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.mgmt.JwkDecryptionKeyManager;
import org.sourceid.oauth20.domain.JWKSEndpointManager;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.services.JWKSService;

public class JwkFacilitator
implements Reloadable {
    private static final Logger log = LoggerFactory.getLogger(JwkFacilitator.class);
    private final ConfigStore configuration = ConfigStoreFarm.getConfig("jwks-endpoint-configuration");
    private Timer timer;
    private double rollPeriodDays = -1.0;
    private volatile JWKSEndpointSetting currentSetting = null;
    public static final Set<String> SUPPORTED_RSA_ALG = Stream.of("RS256", "RS384", "RS512", "PS256", "PS384", "PS512").collect(Collectors.toCollection(HashSet::new));
    private final JwkDecryptionKeyManager jwkDecryptionKeyManager;
    private final CertificateService certificateService;
    private final JWKSEndpointManager jwksEndpointMgr;
    private final JWKSService jwksService;
    private final JsonWebKeysAdderFactory jwksAdderFactory;

    public JwkFacilitator() {
        this(MgmtFactory.getJwkDecryptionKeyManager(), MgmtFactory.getCertificateService(), MgmtFactory.getJWKSEndpointManager(), MgmtFactory.getJWKSService(), new JsonWebKeysAdderFactory());
    }

    public JwkFacilitator(JwkDecryptionKeyManager jwkDecryptionKeyManager, CertificateService certificateService, JWKSEndpointManager jwksEndpointMgr, JWKSService jwksService, JsonWebKeysAdderFactory jwksAdderFactory) {
        this.jwkDecryptionKeyManager = jwkDecryptionKeyManager;
        this.certificateService = certificateService;
        this.jwksEndpointMgr = jwksEndpointMgr;
        this.jwksService = jwksService;
        this.jwksAdderFactory = jwksAdderFactory;
        this.reload();
    }

    public synchronized void createKeys() {
        JWKSEndpointSetting setting = this.jwksEndpointMgr.getSetting();
        this.createKeys(setting);
    }

    public synchronized void createKeys(JWKSEndpointSetting setting) {
        Objects.requireNonNull(setting, "Setting");
        if (setting.equals(this.currentSetting) && !setting.isEnableStaticKeys()) {
            log.debug("JwkFacilitator already initialized with setting: {}", (Object)setting);
            return;
        }
        this.currentSetting = new JWKSEndpointSetting(setting);
        log.info("Using JwkFacilitator() {} with {}", (Object)this, (Object)this.getJwksAdder());
        if (setting.isEnableStaticKeys()) {
            if (this.timer != null) {
                log.debug("Canceling key rotation timer.");
                this.timer.cancel();
            }
            this.getJwkState().setRollPeriodDays(-1.0);
            log.debug("Creating static keys");
            this.addStaticKeys();
        } else {
            log.debug("Using dynamic keys");
            this.rollPeriodDays = -1.0;
            this.reloadRotationConfigAndSchedule();
            log.debug("Creating initial keys ...");
            this.addSavedKeys();
            this.addNewKeys();
            this.addNewKeys();
        }
    }

    @Override
    public synchronized void reload() {
        this.reloadRotationConfigAndSchedule();
        this.createKeys();
    }

    private synchronized void reloadRotationConfigAndSchedule() {
        double rollPeriodFromConfig = this.configuration.getDoubleValue("dynamic-rotation-period-in-days", 7.0);
        if (this.rollPeriodDays != rollPeriodFromConfig) {
            this.rollPeriodDays = rollPeriodFromConfig;
            this.getJwkState().setRollPeriodDays(this.rollPeriodDays);
            double rollPeriodMillsD = this.rollPeriodDays * 24.0 * 60.0 * 60.0 * 1000.0;
            long rollPeriodMills = (long)rollPeriodMillsD;
            if (this.timer != null) {
                log.debug("Canceling key rotation timer (so it can be rescheduled).");
                this.timer.cancel();
            }
            this.timer = new Timer(this.getClass().getName() + " timer", true);
            long delay = rollPeriodMills;
            long lastUpdate = this.getJwkState().getLastUpdate();
            if (lastUpdate > 0L) {
                long nextUpdate = lastUpdate + rollPeriodMills;
                delay = nextUpdate - System.currentTimeMillis();
                delay = delay < 0L ? rollPeriodMills : delay;
            }
            log.debug("scheduling key rotation timer at {} days / {} ms with initial delay of {} ms", new Object[]{this.rollPeriodDays, rollPeriodMills, delay});
            this.timer.schedule((TimerTask)new TimerTaskBase(){

                @Override
                public void doTask() {
                    JwkFacilitator.this.addNewKeys();
                }
            }, delay, rollPeriodMills);
        }
    }

    private JwkState getJwkState() {
        return this.getJwksAdder().getJwkState();
    }

    private void addStaticKeys() {
        this.getJwksAdder().addKeys(this.getStaticKeyMaker());
    }

    private void addNewKeys() {
        this.getJwksAdder().addKeys(this.getDynamicKeyMaker());
    }

    private void addSavedKeys() {
        this.getJwksAdder().addKeys(this.getSavedKeyMaker());
    }

    private synchronized JsonWebKeysAdder getJwksAdder() {
        boolean usingStaticKeys = this.currentSetting != null && this.currentSetting.isEnableStaticKeys();
        return this.jwksAdderFactory.getJwksAdder(usingStaticKeys);
    }

    public JwkWrapper getCurrentRsaKey(String signingAlgorithm) {
        return this.getRsaJwkWrapper(signingAlgorithm, this.getJwkState().getKeys());
    }

    private JwkWrapper getRsaJwkWrapper(String signingAlgorithm, List<JwkWrapper> jwkWrappers) {
        JwkWrapper rsaJwkWrapperNoAlg = null;
        JwkWrapper rsa256JwkWrapper = null;
        for (JwkWrapper jwkWrapper : jwkWrappers) {
            if (!"RSA".equals(jwkWrapper.getJwk().getKeyType()) || jwkWrapper.getLifecycleState() != JwkLifecycleState.ACTIVE) continue;
            String jwkAlg = jwkWrapper.getJwk().getAlgorithm();
            if (StringUtils.isEmpty((String)jwkAlg)) {
                if (signingAlgorithm == null) {
                    return jwkWrapper;
                }
                rsaJwkWrapperNoAlg = jwkWrapper;
            } else if (jwkAlg.equals(signingAlgorithm)) {
                return jwkWrapper;
            }
            if (!"RS256".equals(jwkAlg)) continue;
            rsa256JwkWrapper = jwkWrapper;
        }
        if (rsaJwkWrapperNoAlg == null && rsa256JwkWrapper != null) {
            return rsa256JwkWrapper;
        }
        return rsaJwkWrapperNoAlg;
    }

    public JwkWrapper getCurrentEcKey(String curveName) {
        for (JwkWrapper rapper : this.getJwkState().getKeys()) {
            EllipticCurveJsonWebKey ecJwk;
            JsonWebKey jwk = rapper.getJwk();
            if (!"EC".equals(jwk.getKeyType()) || rapper.getLifecycleState() != JwkLifecycleState.ACTIVE || !(ecJwk = (EllipticCurveJsonWebKey)jwk).getCurveName().equals(curveName)) continue;
            return rapper;
        }
        return null;
    }

    public JwkWrapper getKeyById(String kid) {
        return this.getJwkState().getKeyById(kid);
    }

    public List<JsonWebKey> getEncryptionKeys() {
        LinkedList<JsonWebKey> jwkSet = new LinkedList<JsonWebKey>();
        for (JwkWrapper jwkWrapper : this.getJwkState().getEncryptionKeys()) {
            PublicJsonWebKey key = (PublicJsonWebKey)jwkWrapper.getJwk();
            key.setPrivateKey(jwkWrapper.getPrivateKey());
            jwkSet.add((JsonWebKey)key);
        }
        return jwkSet;
    }

    public JsonWebKeySet getJsonWebKeySet() {
        LinkedList<JsonWebKey> jwkSet = new LinkedList<JsonWebKey>();
        for (JwkWrapper jwkWrapper : this.getJwkState().getKeys()) {
            jwkSet.add(jwkWrapper.getJwk());
        }
        for (JwkWrapper jwkWrapper : this.getJwkState().getEncryptionKeys()) {
            if (jwkWrapper.getLifecycleState() != JwkLifecycleState.ACTIVE) continue;
            jwkSet.add(jwkWrapper.getJwk());
        }
        return new JsonWebKeySet(jwkSet);
    }

    public JwkWrapper getCurrentRsaKey(String oAuthIssuerInstanceId, String signingAlgorithm) {
        if (this.issuerKeysetExists(oAuthIssuerInstanceId)) {
            return this.getRsaJwkWrapper(signingAlgorithm, this.getJwkState().getKeys(oAuthIssuerInstanceId));
        }
        return this.getCurrentRsaKey(signingAlgorithm);
    }

    public JwkWrapper getCurrentEcKey(String curveName, String oAuthIssuerInstanceId) {
        if (this.issuerKeysetExists(oAuthIssuerInstanceId)) {
            for (JwkWrapper wrapper : this.getJwkState().getKeys(oAuthIssuerInstanceId)) {
                EllipticCurveJsonWebKey ecJwk;
                JsonWebKey jwk = wrapper.getJwk();
                if (!"EC".equals(jwk.getKeyType()) || !JwkLifecycleState.ACTIVE.equals((Object)wrapper.getLifecycleState()) || !(ecJwk = (EllipticCurveJsonWebKey)jwk).getCurveName().equals(curveName)) continue;
                return wrapper;
            }
        } else {
            return this.getCurrentEcKey(curveName);
        }
        return null;
    }

    public Map<String, Map<String, JwkWrapper>> getIssuerToAdditionalSigningKeys() {
        Map<String, Map<String, JwkWrapper>> issuerToAdditionalSigningKeys = this.getJwkState().getAdditionalSigningKeys();
        if (issuerToAdditionalSigningKeys == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(issuerToAdditionalSigningKeys);
    }

    public JsonWebKeySet getJsonWebKeySet(String oAuthIssuerInstanceId) {
        LinkedList<JsonWebKey> jwkSet = new LinkedList<JsonWebKey>();
        if (this.issuerKeysetExists(oAuthIssuerInstanceId)) {
            for (JwkWrapper jwkWrapper : this.getJwkState().getKeys(oAuthIssuerInstanceId)) {
                jwkSet.add(jwkWrapper.getJwk());
            }
            for (JwkWrapper jwkWrapper : this.getJwkState().getEncryptionKeys()) {
                if (jwkWrapper.getLifecycleState() != JwkLifecycleState.ACTIVE) continue;
                jwkSet.add(jwkWrapper.getJwk());
            }
            return new JsonWebKeySet(jwkSet);
        }
        return this.getJsonWebKeySet();
    }

    public boolean isX5tAvailable() {
        if (this.currentSetting == null) {
            return false;
        }
        if (this.currentSetting.isEnableStaticKeys()) {
            return true;
        }
        return this.currentSetting.getDynamicKeys().isPublishCertificates();
    }

    private boolean issuerKeysetExists(String oAuthIssuerInstanceId) {
        List<JwkWrapper> issuerBasedWrappedJwks = this.getJwkState().getKeys(oAuthIssuerInstanceId);
        return issuerBasedWrappedJwks != null && !issuerBasedWrappedJwks.isEmpty();
    }

    public List<JsonWebKey> getSigningJsonWebKeys() {
        return this.getJwkState().getKeys().stream().map(JwkWrapper::getJwk).collect(Collectors.toList());
    }

    synchronized DynamicKeyMaker getDynamicKeyMaker() {
        double certValidityMultiplierFactor = this.configuration.getDoubleValue("dynamic-cert-validity-multiplier", 5.0);
        if (certValidityMultiplierFactor < 1.0) {
            log.warn("Invalid value for dynamic-cert-validity-multiplier: {}. Using default value of 5.", (Object)certValidityMultiplierFactor);
            certValidityMultiplierFactor = 5.0;
        }
        int certValidityInDays = (int)Math.ceil(this.rollPeriodDays * certValidityMultiplierFactor);
        int rsaKeySize = this.configuration.getIntValue("dynamic-rsa-key-size", 2048);
        int cnSuffixLength = this.configuration.getIntValue("cn-suffix-length", 22);
        if (cnSuffixLength < 1) {
            log.warn("Invalid value for cn-suffix-length: {}. Using default value of 22.", (Object)cnSuffixLength);
            cnSuffixLength = 22;
        }
        return new DynamicKeyMaker(this.jwksEndpointMgr, this.certificateService, rsaKeySize, certValidityInDays, cnSuffixLength);
    }

    synchronized SavedKeyMaker getSavedKeyMaker() {
        return new SavedKeyMaker(this.jwkDecryptionKeyManager, this.rollPeriodDays);
    }

    private synchronized StaticKeyMaker getStaticKeyMaker() {
        return new StaticKeyMaker(this.jwksEndpointMgr, this.jwksService);
    }
}

