/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.SecurityProviderUtil;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;

public class JwkKeyRep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PKCS8 = "PKCS#8";
    private static final String X509 = "X.509";
    private KeyRep.Type type;
    private String algorithm;
    private String format;
    private byte[] encoded;
    private String provider;

    public JwkKeyRep(KeyRep.Type type, Key key) {
        this.type = type;
        this.algorithm = key.getAlgorithm();
        this.format = key.getFormat().toUpperCase(Locale.ENGLISH);
        this.encoded = key.getEncoded();
        switch (key.getAlgorithm()) {
            case "EC": {
                this.provider = SecurityProviderUtil.getSunECProviderOrEquivalent();
                break;
            }
            case "RSA": {
                this.provider = SecurityProviderUtil.getSunRsaSignProviderOrEquivalent();
                break;
            }
            default: {
                this.provider = null;
            }
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            if (this.type == KeyRep.Type.PUBLIC && X509.equals(this.format)) {
                KeyFactory f = this.getKeyFactory();
                return f.generatePublic(new X509EncodedKeySpec(this.encoded));
            }
            if (this.type == KeyRep.Type.PRIVATE && PKCS8.equals(this.format)) {
                KeyFactory f = this.getKeyFactory();
                return f.generatePrivate(new PKCS8EncodedKeySpec(this.encoded));
            }
            throw new InvalidObjectException("unrecognized type/format combination: " + this.type + "/" + this.format);
        }
        catch (Exception e) {
            NotSerializableException nse = new NotSerializableException("java.security.Key: [" + this.type + "] [" + this.algorithm + "] [" + this.format + "]");
            nse.initCause(e);
            throw nse;
        }
    }

    private KeyFactory getKeyFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.provider == null) {
            return KeyFactory.getInstance(this.algorithm);
        }
        return KeyFactory.getInstance(this.algorithm, this.provider);
    }

    public static enum Type {
        PUBLIC,
        PRIVATE;

    }
}

