/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.crypto.jwk.JwkKeyPair;
import com.pingidentity.crypto.jwk.JwkLifecycleState;
import com.pingidentity.crypto.jwk.JwksAdditionalKeysContent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;

public class JwksContent
implements Serializable {
    private boolean removeAllKeys;
    private List<JwkKeyPair> keyPairs;
    private List<JwkKeyPair> encryptionKeyPairs;
    private transient JwksAdditionalKeysContent additionalKeysContent;
    private static final long serialVersionUID = 1L;
    private transient JWKSEndpointSetting jwkEndpointSetting;

    public JwksContent(List<JwkKeyPair> keyPairs) {
        this.keyPairs = keyPairs;
    }

    private JwksContent(List<JwkKeyPair> keyPairs, List<JwkKeyPair> encryptionKeyPairs) {
        this.keyPairs = keyPairs;
        this.encryptionKeyPairs = encryptionKeyPairs;
    }

    public JwksContent(List<JwkKeyPair> keyPairs, List<JwkKeyPair> encryptionKeyPairs, boolean removeAllKeys) {
        this(keyPairs, encryptionKeyPairs);
        this.removeAllKeys = removeAllKeys;
    }

    public JwksContent(List<JwkKeyPair> keyPairs, List<JwkKeyPair> encryptionKeyPairs, boolean removeAllKeys, JwksAdditionalKeysContent additionalKeysContent, JWKSEndpointSetting jwkEndpointSetting) {
        this(keyPairs, encryptionKeyPairs, removeAllKeys);
        this.additionalKeysContent = additionalKeysContent;
        this.jwkEndpointSetting = jwkEndpointSetting;
    }

    public boolean isRemoveAllKeys() {
        return this.removeAllKeys;
    }

    public List<JwkKeyPair> getKeys() {
        return this.keyPairs;
    }

    public List<JwkKeyPair> getEncryptionKeys() {
        return this.encryptionKeyPairs;
    }

    public JwksAdditionalKeysContent getAdditionalKeys() {
        return this.additionalKeysContent;
    }

    public boolean isDuplicateRsaWithAlg(JwkLifecycleState jwkLifecycleState) {
        if (JwkLifecycleState.ACTIVE == jwkLifecycleState && this.jwkEndpointSetting != null && this.jwkEndpointSetting.getRsaAlgTypesActiveCustomKeyIds() != null && this.hasRsa256KeyId(this.jwkEndpointSetting.getRsaAlgTypesActiveCustomKeyIds())) {
            return false;
        }
        return JwkLifecycleState.RETIRED != jwkLifecycleState || this.jwkEndpointSetting == null || this.jwkEndpointSetting.getRsaAlgTypesPreviousCustomKeyIds() == null || !this.hasRsa256KeyId(this.jwkEndpointSetting.getRsaAlgTypesPreviousCustomKeyIds());
    }

    private boolean hasRsa256KeyId(Map<String, String> rsaAlgToKeyId) {
        return !rsaAlgToKeyId.isEmpty() && rsaAlgToKeyId.containsKey("RS256");
    }
}

