/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto.jwk;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.jwk.MasterKeySet;
import com.pingidentity.sdk.key.MasterKeyEncryptor;
import com.pingidentity.sdk.key.MasterKeyEncryptorException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.lang.JoseException;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class MasterKeySetImpl
implements MasterKeySet,
AutoReloadable {
    private static final String CONFIG_KEY_ID = "keyId";
    private static final String CONFIG_JWK_ENC = "jwkEncrypted";
    private final SysDirInfo SYS_DIR_INFO = GlobalRegistry.getService(SysDirInfo.class);
    private final Path JWK_PATH = FileSystems.getDefault().getPath(this.SYS_DIR_INFO.getDataDirectory(), "pf.jwk");
    private final Log LOG = LogFactory.getLog(MasterKeySetImpl.class);
    private JsonWebKeySet jsonWebKeySet;
    private final MasterKeyEncryptor encryptor;

    public MasterKeySetImpl(MasterKeyEncryptor encryptor) {
        this.encryptor = encryptor;
        this.initializeJsonWebKeySet();
    }

    @Override
    public synchronized void reload() {
        ConfigStore masterKeySetConfig = ConfigStoreFarm.getConfig(MasterKeySet.class);
        masterKeySetConfig.reload();
        this.initializeJsonWebKeySet();
    }

    @Override
    public synchronized JsonWebKeySet getJsonWebKeySet() {
        return this.jsonWebKeySet;
    }

    @Override
    public synchronized void addJsonWebKeySet(JsonWebKeySet newKeySet) {
        for (JsonWebKey jwk : newKeySet.getJsonWebKeys()) {
            if (this.jsonWebKeySet.findJsonWebKey(jwk.getKeyId(), jwk.getKeyType(), jwk.getUse(), jwk.getAlgorithm()) != null) continue;
            this.jsonWebKeySet.getJsonWebKeys().add(jwk);
        }
        this.saveJsonWebKeySet();
    }

    @Override
    public synchronized JsonWebKey addNewKeyToFirstPosition() {
        JsonWebKey newKey = this.createNewJsonWebKey();
        this.jsonWebKeySet.getJsonWebKeys().add(0, newKey);
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            scope.log(AdminAuditLogger.Component.CONFIGURATION_ENCRYPTION_KEYS, AdminAuditLogger.Event.ROTATE, newKey.getKeyId());
        }
        this.saveJsonWebKeySet();
        return newKey;
    }

    @Override
    public synchronized void deleteKeysFromKeySet(JsonWebKeySet keysToDelete) {
        JsonWebKeySet newKeySet = new JsonWebKeySet(new JsonWebKey[0]);
        for (JsonWebKey existingKey : this.jsonWebKeySet.getJsonWebKeys()) {
            if (keysToDelete.findJsonWebKey(existingKey.getKeyId(), existingKey.getKeyType(), existingKey.getUse(), existingKey.getAlgorithm()) != null) continue;
            newKeySet.addJsonWebKey(existingKey);
        }
        this.jsonWebKeySet = newKeySet;
        this.saveJsonWebKeySet();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void initializeJsonWebKeySet() {
        masterKeySetConfig = ConfigStoreFarm.getConfig(MasterKeySet.class);
        keyId = masterKeySetConfig.getStringValue("keyId", null);
        jwkEncrypted = masterKeySetConfig.getBooleanValue("jwkEncrypted", false);
        keyIdChanged = false;
        oldKeyId = keyId;
        try {
            keyId = this.encryptor.initialize(keyId);
            keyIdChanged = keyId != null && (oldKeyId == null || keyId.equals(oldKeyId) == false);
        }
        catch (MasterKeyEncryptorException e) {
            throw new RuntimeException("Unable to initialize the MasterKeyEncryptor!", e);
        }
        if (Files.isRegularFile(this.JWK_PATH, new LinkOption[0])) {
            try {
                fileBytes = Files.readAllBytes(this.JWK_PATH);
                if (jwkEncrypted) {
                    fileBytes = this.encryptor.decrypt(fileBytes);
                }
                this.jsonWebKeySet = new JsonWebKeySet(new String(fileBytes, StandardCharsets.UTF_8));
                if (jwkEncrypted && !keyIdChanged) ** GOTO lbl32
                this.saveJsonWebKeySet(true);
            }
            catch (IOException | JoseException e) {
                throw new RuntimeException("Error reading the JSON web key set", e);
            }
            catch (MasterKeyEncryptorException e) {
                throw new RuntimeException("Unable to decrypt the master key set!", e);
            }
        } else {
            jwk = this.createNewJsonWebKey();
            jwks = new ArrayList<JsonWebKey>();
            jwks.add(jwk);
            this.jsonWebKeySet = new JsonWebKeySet(jwks);
            this.LOG.info((Object)("created key with id: " + jwk.getKeyId()));
            this.saveJsonWebKeySet();
        }
lbl32:
        // 3 sources

        if (!StringUtils.equals((String)oldKeyId, (String)keyId)) {
            masterKeySetConfig.setStringValue("keyId", keyId);
        }
    }

    private JsonWebKey createNewJsonWebKey() {
        OctetSequenceJsonWebKey newKey = OctJwkGenerator.generateJwk((int)256);
        Instant currentTime = Instant.now();
        newKey.setOtherParameter("creationDate", (Object)currentTime.getEpochSecond());
        newKey.setKeyId(IDGenerator.rndAlphaNumeric(10));
        return newKey;
    }

    private synchronized void saveJsonWebKeySet() {
        this.saveJsonWebKeySet(false);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private synchronized void saveJsonWebKeySet(boolean onlyIfEncryptionPerformed) {
        ConfigStore masterKeySetConfig = ConfigStoreFarm.getConfig(MasterKeySet.class);
        try {
            boolean encryptionPerformed;
            byte[] plainText = this.jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC).getBytes(StandardCharsets.UTF_8);
            byte[] cipherText = this.encryptor.encrypt(plainText);
            boolean bl = encryptionPerformed = !Arrays.equals(plainText, cipherText);
            if (onlyIfEncryptionPerformed && !encryptionPerformed) {
                return;
            }
            Files.createDirectories(this.JWK_PATH.getParent(), new FileAttribute[0]);
            if (Files.exists(this.JWK_PATH, new LinkOption[0]) && !Files.isWritable(this.JWK_PATH)) {
                this.JWK_PATH.toFile().setWritable(true);
            }
            Files.write(this.JWK_PATH, cipherText, new OpenOption[0]);
            masterKeySetConfig.setBooleanValue(CONFIG_JWK_ENC, encryptionPerformed);
            this.JWK_PATH.toFile().setExecutable(false, false);
            this.JWK_PATH.toFile().setWritable(false, false);
            this.JWK_PATH.toFile().setReadable(false, false);
            this.JWK_PATH.toFile().setReadable(true);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing the JSON web key", e);
        }
        catch (MasterKeyEncryptorException e) {
            throw new RuntimeException("Unable to encrypt the master key set!", e);
        }
    }
}

