/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.email;

import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.email.EmailLanguagePackMessagesImpl;
import com.pingidentity.pf.email.EmailUtilSystemSettings;
import com.pingidentity.pf.email.lang.EmailLanguagePackMessages;
import com.pingidentity.pf.email.util.Sender;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.sourceid.common.VelocityTemplateUtils;
import org.sourceid.config.GlobalRegistry;

public class EmailUtilSystemSettingsImpl
implements EmailUtilSystemSettings {
    private static final Log log = LogFactory.getLog(EmailUtilSystemSettingsImpl.class);
    private static final String EMAIL_TEMPLATES_DIR = "mail-notifications";
    private static final EmailUtilSystemSettings instance = new EmailUtilSystemSettingsImpl();
    private VelocityEngine velocityEngine = null;

    private EmailUtilSystemSettingsImpl() {
        this.initVelocityTemplate();
    }

    private void initVelocityTemplate() {
        Properties props = VelocityTemplateUtils.getVelocityProperties(this.getPfTemplatesDirectoryPath() + File.separator + EMAIL_TEMPLATES_DIR);
        this.velocityEngine = new VelocityEngine(props);
        try {
            this.velocityEngine.init();
        }
        catch (Exception e) {
            log.error((Object)"Unable to initialize Velocity for Email templates.", (Throwable)e);
        }
    }

    public static EmailUtilSystemSettings getInstance() {
        return instance;
    }

    public Sender getSender() {
        return GlobalRegistry.getService(Sender.class);
    }

    public String getPfTemplatesDirectoryPath() {
        return GlobalRegistry.getService(SysDirInfo.class).getTemplateDirectory();
    }

    public TrustManager[] getTrustManagers() {
        return new TrustManager[]{PingSslClientTrustManager.getInstance()};
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public Context getVelocityToolsContext() {
        return VelocityTemplateUtils.getVelocityToolContext();
    }

    public EmailLanguagePackMessages getEmailLanguagePackMessages(Locale locale) {
        return new EmailLanguagePackMessagesImpl(locale);
    }
}

