/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.email.mgmt;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.email.mgmt.NotificationDispatcherManager;
import com.pingidentity.email.util.NotificationSenderFactory;
import com.pingidentity.sdk.notification.NotificationPublisherPlugin;
import com.pingidentity.sdk.notification.NotificationSenderPluginDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;

public class NotificationDispatcherManagerImpl
implements NotificationDispatcherManager {
    private static final Log log = LogFactory.getLog(NotificationDispatcherManagerImpl.class);
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public void dispatchNotification(String pluginId, String eventType, Map<String, Object> data, Map<String, String> configuration) {
        NotificationPublisherPlugin sender = NotificationSenderFactory.getSender(pluginId);
        if (sender != null) {
            String trackingId;
            Object baseUrl = BaseUrlAccessor.getCurrentBaseUrl();
            if (StringUtils.isNotBlank((String)baseUrl) && !((String)baseUrl).endsWith("/")) {
                baseUrl = (String)baseUrl + "/";
            }
            data.put("BASE_URL", baseUrl);
            Object pfBaseUrl = MetaDataFactory.getLocalMetaData().getBaseUrl();
            if (StringUtils.isNotBlank((String)pfBaseUrl) && !((String)pfBaseUrl).endsWith("/")) {
                pfBaseUrl = (String)pfBaseUrl + "/";
            }
            data.put("PingFedBaseURL", pfBaseUrl);
            String currentPfBaseUrl = BaseUrlUtil.getCurrentBaseUrl((String)pfBaseUrl);
            data.put("CurrentPingFedBaseURL", currentPfBaseUrl);
            String transactionId = TransactionIdSupport.getTransactionId();
            if (transactionId != null) {
                data.put("TransactionId", transactionId);
            }
            if ((trackingId = TrackingIdSupport.getTrackingId()) != null) {
                data.put("TrackingId", trackingId);
            }
            if (!sender.acceptsUserAttributes()) {
                data.remove("userAttributes");
            }
            if (((NotificationSenderPluginDescriptor)sender.getPluginDescriptor()).getSupportsObjectData()) {
                this.executorService.submit(() -> sender.publishNotificationWithObjectData(eventType, data, configuration));
            } else {
                Map<String, String> stringData = this.flattenObjectData(data);
                this.executorService.submit(() -> sender.publishNotification(eventType, stringData, configuration));
            }
        } else if (StringUtils.isEmpty((String)pluginId)) {
            log.error((Object)String.format("Unable to dispatch notification using default notification publisher for event type '%s'", eventType));
        } else {
            log.error((Object)String.format("Unable to dispatch notification using plugin '%s' for event type '%s'", pluginId, eventType));
        }
    }

    private Map<String, String> flattenObjectData(Map<String, Object> data) {
        HashMap<String, String> stringData = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getValue() instanceof String) {
                stringData.put(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                Map mapData = (Map)entry.getValue();
                for (Map.Entry mapEntry : mapData.entrySet()) {
                    stringData.put(entry.getKey() + "." + (String)mapEntry.getKey(), (String)mapEntry.getValue());
                }
                continue;
            }
            stringData.put(entry.getKey(), entry.getValue().toString());
        }
        return stringData;
    }
}

