/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.helper;

import com.pingidentity.pingid.PingIdInitialSetupAdminService;
import com.pingidentity.pingone.PingOneAdminService;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.SpConnectionFactory;

public class BridgeHelper {
    private final PingIdInitialSetupAdminService pingIdServer = MgmtFactory.getPingIdInitialSetupAdminService();
    private final PingOneAdminService pingOneAdminService = MgmtFactory.getPingOneAdminService();
    private final PingOneAdminService adminService = MgmtFactory.getPingOneAdminService();

    public static BridgeHelper getInstance() {
        return new BridgeHelper();
    }

    public BridgeMode getBridgeMode() {
        boolean hasSpConn = this.pingOneAdminService.getSpConnectionFactory().hasManagedSpConnection();
        boolean isPingIdCase = false;
        if (this.pingIdServer.getPCV() != null) {
            isPingIdCase = true;
        }
        if (this.pingIdServer.getProvisioningConnection() != null) {
            isPingIdCase = true;
        }
        if (hasSpConn && isPingIdCase) {
            return BridgeMode.BRIDGE_ALL;
        }
        if (hasSpConn) {
            return BridgeMode.BRIDGE_SSO;
        }
        if (isPingIdCase) {
            return BridgeMode.BRIDGE_RADIUS;
        }
        return null;
    }

    public String getPingIdConnectionName() {
        ConnectionBase connection = this.pingIdServer.getProvisioningConnection();
        if (connection == null) {
            return null;
        }
        return connection.getName();
    }

    public String getPingIdPcvName() {
        PasswordCredentialValidatorInstance pcv = this.pingIdServer.getPCV();
        if (pcv == null) {
            return null;
        }
        return pcv.getName();
    }

    public String getSpConnectionName() {
        SpConnectionFactory connFactory = this.pingOneAdminService.getSpConnectionFactory();
        if (!connFactory.hasManagedSpConnection()) {
            return null;
        }
        return connFactory.getManagedSpConnection().getName();
    }

    public boolean isPingIDConfigured() {
        return this.getPingIdPcvName() != null || this.getPingIdConnectionName() != null;
    }

    public boolean isPingOneSSOConfigured() {
        return this.getSpConnectionName() != null;
    }

    public String getPingOneApplicationURL() {
        return this.adminService.getMetadata().getAddApplicationUrl();
    }

    public static enum BridgeMode {
        BRIDGE_ALL("bridge-all"),
        BRIDGE_RADIUS("bridge-radius"),
        BRIDGE_SSO("bridge-sso");

        private final String cssClass;

        private BridgeMode(String cssClass) {
            this.cssClass = cssClass;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }
}

