/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hivemind;

import com.pingidentity.configservice.ReloadRegisterable;
import com.pingidentity.configservice.ReloadRegistry;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.hivemind.ServiceSet;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceSetManager
implements ReloadRegisterable {
    private static final Log log = LogFactory.getLog(ServiceSetManager.class);
    private static ServiceSetManager instance = new ServiceSetManager();
    private volatile ServiceSet pendingServiceSet;
    private ServiceSetReference activeServiceSetRef;
    private List<WeakReference<ServiceSetReference>> previousServiceSetRefs = new LinkedList<WeakReference<ServiceSetReference>>();
    private final ThreadLocal<ServiceSetReference> threadServiceSetRef = new ThreadLocal();
    private ReloadRegistry reloadRegistry = new ReloadRegistry();

    public static ServiceSetManager getDefault() {
        return instance;
    }

    private ServiceSetManager() {
    }

    public synchronized void activatePendingServiceSet() {
        if (this.pendingServiceSet == null) {
            throw new IllegalStateException("Pending service set is null");
        }
        this.previousServiceSetRefs.add(new WeakReference<ServiceSetReference>(this.activeServiceSetRef));
        this.activeServiceSetRef = new ServiceSetReference(this.pendingServiceSet);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting active service set ref to " + this.activeServiceSetRef));
        }
        this.pendingServiceSet = null;
    }

    public synchronized void createPendingServiceSet() {
        this.pendingServiceSet = new ServiceSet();
        this.updatePreviousServiceSetRefs(this.activeServiceSetRef.get());
    }

    public synchronized void clearPendingServiceSet() {
        this.pendingServiceSet = null;
    }

    public ServiceSet getThreadServiceSet() {
        if (this.threadServiceSetRef.get() != null) {
            return this.threadServiceSetRef.get().get();
        }
        ServiceSet pendingServiceSetLocal = this.pendingServiceSet;
        if (pendingServiceSetLocal != null) {
            return pendingServiceSetLocal;
        }
        return this.getActiveServiceSetRef().get();
    }

    public RuntimeServiceSetScope newRuntimeServiceSetScope() {
        return new RuntimeServiceSetScope();
    }

    public void setRuntimeThreadServiceSet() {
        ServiceSetReference activeServiceSetRef = this.getActiveServiceSetRef();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting thread service set, ref=" + activeServiceSetRef));
        }
        this.threadServiceSetRef.set(activeServiceSetRef);
    }

    public void removeRuntimeThreadServiceSet() {
        this.threadServiceSetRef.remove();
    }

    @Override
    public void registerForReloadEvents(Reloadable reloadable) {
        this.reloadRegistry.registerForReloadEvents(reloadable);
    }

    @Override
    public void reload() {
        this.reloadRegistry.reload();
    }

    private synchronized void updatePreviousServiceSetRefs(ServiceSet activeServiceSet) {
        Iterator<WeakReference<ServiceSetReference>> iter = this.previousServiceSetRefs.iterator();
        while (iter.hasNext()) {
            WeakReference<ServiceSetReference> refRef = iter.next();
            ServiceSetReference ref = (ServiceSetReference)refRef.get();
            if (ref == null) {
                iter.remove();
                continue;
            }
            ref.set(activeServiceSet);
        }
    }

    private synchronized ServiceSetReference getActiveServiceSetRef() {
        if (this.activeServiceSetRef == null) {
            this.activeServiceSetRef = new ServiceSetReference(new ServiceSet());
        }
        return this.activeServiceSetRef;
    }

    private static class ServiceSetReference {
        private volatile ServiceSet serviceSet;

        public ServiceSetReference(ServiceSet serviceSet) {
            this.serviceSet = serviceSet;
        }

        public ServiceSet get() {
            return this.serviceSet;
        }

        void set(ServiceSet serviceSet) {
            this.serviceSet = serviceSet;
        }
    }

    public class RuntimeServiceSetScope
    implements AutoCloseable {
        private ServiceSetReference prevServiceSetRef;

        public RuntimeServiceSetScope() {
            this.prevServiceSetRef = ServiceSetManager.this.threadServiceSetRef.get();
            ServiceSetManager.this.setRuntimeThreadServiceSet();
        }

        @Override
        public void close() {
            ServiceSetManager.this.threadServiceSetRef.set(this.prevServiceSetRef);
        }
    }
}

