/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hsm;

import com.amazonaws.cloudhsm.jce.jni.exception.ProviderInitializationException;
import com.amazonaws.cloudhsm.jce.provider.CloudHsmProvider;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.PasswordFile;
import com.pingidentity.hsm.HSMStarter;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.util.SystemUtil;

public class CloudHSMStarter
extends HSMStarter {
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.crypto.AWSCloudHSM");
    private static final String CLOUD_HSM_PROVIDER_NAME = "CloudHSM";

    public CloudHSMStarter(Log log) {
        super(log);
    }

    @Override
    public void start() throws ProviderInitializationException, LoginException, IOException {
        String dataDir = PropertyInfo.getHsmDataDirPath();
        File hsmpassFile = new File(dataDir, "hsmpasswd.txt");
        if (!hsmpassFile.exists()) {
            SystemUtil.hardShutdown("The hsmpass.txt was not found.  Please run the hsmpass utility located in <pf_install>/bin.  See PingFederate documentation for further instructions on using this utility with an HSM.");
        }
        this.checkDisableTLS13AndRSASSAPSS();
        try {
            String partition = configStore.getStringValue("Partition");
            String cryptoUser = configStore.getStringValue("CryptoUser");
            this.setHSMCredentialsProperties(dataDir, partition, cryptoUser);
        }
        catch (NoSuchValueException ex) {
            SystemUtil.hardShutdown("AWS CloudHSM unavailable: Cannot read find partition or the crypto user.");
        }
        if (PropertyInfo.isHSMUpdateProviderList()) {
            this.updateProviderList((Provider)new CloudHsmProvider());
        }
        this.checkCloudHSMClientSDKVersion();
    }

    private void setHSMCredentialsProperties(String dataDir, String partition, String cryptoUser) {
        System.setProperty("HSM_PARTITION", partition);
        System.setProperty("HSM_USER", cryptoUser);
        try {
            System.setProperty("HSM_PASSWORD", PasswordFile.getAndDeobfuscateHSMPassword(dataDir));
        }
        catch (Exception ex) {
            SystemUtil.hardShutdown(ex.getMessage(), ex);
        }
    }

    private void checkCloudHSMClientSDKVersion() {
        Provider cloudHsmProvider = Security.getProvider(CLOUD_HSM_PROVIDER_NAME);
        if (cloudHsmProvider != null) {
            this.log.info((Object)("Cloud HSM provider version is " + cloudHsmProvider.getVersion()));
            if (cloudHsmProvider.getVersion() < 5.0) {
                SystemUtil.hardShutdown("AWS CloudHSM client SDK is not version 5 or higher. Please upgrade.");
            }
        } else {
            SystemUtil.hardShutdown("Could not find the CloudHSM Provider.");
        }
    }
}

