/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.hsm;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.hsm.HSMStarter;
import java.io.File;
import java.security.Provider;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.util.SystemUtil;

public class NCipherStarter
extends HSMStarter {
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.crypto.NCipherSettings");
    private static final String CFG_PROTECT = "protect";
    private static final String CFG_MODULE = "module";
    private static final String CFG_SLOT = "slot";
    private static final String CFG_IGNORE_PASSPHRASE = "ignorePassphrase";

    public NCipherStarter(Log log) {
        super(log);
    }

    @Override
    public void start() throws Exception {
        this.log.info((Object)"nCipher mode detected");
        this.applySystemProperties();
        String dataDir = PropertyInfo.getHsmDataDirPath();
        File hsmpassFile = new File(dataDir, "hsmpasswd.txt");
        if (!NCipherStarter.isIgnorePassphrase() && !hsmpassFile.exists()) {
            SystemUtil.hardShutdown("The hsmpass.txt was not found.  Please run the hsmpass utility located in <pf_install>/bin.  See PingFederate documentation for further instructions on using this utility with the Entrust nShield Connect HSM.");
        }
        this.checkDisableTLS13AndRSASSAPSS();
        Map<String, String> env = System.getenv();
        String nfastKmLocal = env.get("NFAST_KMLOCAL");
        if (nfastKmLocal != null && !nfastKmLocal.isEmpty()) {
            this.log.info((Object)("NFAST_KMLOCAL = " + nfastKmLocal));
            String expectedNfastKmLocalDirectoryName = "ncipher-kmdata-local";
            File expectedNfastKmLocalDirectory = new File(dataDir, expectedNfastKmLocalDirectoryName);
            String expectedNfastKmLocalDirectoryPath = expectedNfastKmLocalDirectory.getCanonicalPath();
            File nfastKmLocalFile = new File(nfastKmLocal);
            if (!nfastKmLocalFile.isDirectory()) {
                SystemUtil.hardShutdown("The value for environment variable NFAST_KMLOCAL is not a directory or the directory does not exist. Please set the value to " + expectedNfastKmLocalDirectoryPath + ". Then, if needed, create the directory and move all nCipher security world files to it.");
            } else {
                String[] files;
                if (!nfastKmLocalFile.getCanonicalPath().equals(expectedNfastKmLocalDirectoryPath)) {
                    SystemUtil.hardShutdown("The value for environment variable NFAST_KMLOCAL is not set to the " + expectedNfastKmLocalDirectoryName + " directory within this instance of PingFederate. Value should be set to " + expectedNfastKmLocalDirectoryPath + ".");
                }
                if ((files = expectedNfastKmLocalDirectory.list()) == null || files.length == 0) {
                    SystemUtil.hardShutdown("The " + expectedNfastKmLocalDirectoryName + " directory is empty.  Please move all nCipher security world files to " + expectedNfastKmLocalDirectoryPath + ".");
                }
            }
        } else {
            this.log.info((Object)"NFAST_KMLOCAL environment variable not used.");
        }
        if (PropertyInfo.isHSMUpdateProviderList()) {
            try {
                Class<?> providerClass = Class.forName("com.ncipher.provider.km.nCipherKM");
                Provider provider = (Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.updateProviderList(provider);
            }
            catch (Exception e) {
                SystemUtil.hardShutdown("Unable to load nCipherKM provider", e);
            }
        }
    }

    public static boolean isIgnorePassphrase() {
        return Boolean.parseBoolean(System.getProperty(CFG_IGNORE_PASSPHRASE, "false"));
    }

    private void applySystemProperties() {
        for (String property : Arrays.asList(CFG_PROTECT, CFG_MODULE, CFG_SLOT, CFG_IGNORE_PASSPHRASE)) {
            String value = this.configStore.getStringValue(property, null);
            if (!StringUtils.isNotBlank((String)value)) continue;
            System.setProperty(property, value);
        }
    }
}

