/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups;

import com.google.common.net.InetAddresses;
import com.pingidentity.common.util.ErrorHandler;
import com.pingidentity.common.util.InvalidSystemParameterException;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.SystemParameterValidator;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.Password;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.jgroups.org.jgroups.DiscoveryProtocol;
import com.pingidentity.jgroups.org.jgroups.ENCRYPT;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.JChannel;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.SYM_ENCRYPT;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;

public class ChannelFactory {
    private static final String BIND_ADDRESS_DIRECTIVE_KEY = "BIND_ADDRESS_DIRECTIVE";
    private static final String ENCRYPT_TAG_KEY = "ENCRYPT_TAG";
    public static final String DISCOVERY_TAG_KEY = "DISCOVERY_TAG";
    private static final Log log = LogFactory.getLog(ChannelFactory.class);
    private static ChannelFactory defaultFactory;
    private final Properties properties;
    private final String stackname;
    private JChannel jChannel;
    private String validatedBindAddress;
    public static final String CLUSTER_NAME_PROP_NAME = "pf.cluster.name";
    public static final String BIND_ADDRESS_PROP_NAME = "pf.cluster.bind.address";
    public static final String BIND_PORT_RANGE_PROP_NAME = "pf.cluster.bind.port.range";
    public static final String AUTH_PROP_NAME = "pf.cluster.auth.pwd";
    public static final String ENCRYPT_PROP_NAME = "pf.cluster.encrypt";
    public static final String INIT_HOSTS_PROP_NAME = "pf.cluster.tcp.discovery.initial.hosts";
    static final String FD_SOCK_BIND_PORT_NAME = "pf.cluster.failure.detection.bind.port";
    private static final String BIND_PORT = "pf.cluster.bind.port";
    private static final String MCAST_PORT = "pf.cluster.mcast.group.port";
    private static final String TRANSPORT_PROTOCOL = "pf.cluster.transport.protocol";
    private static final String DIAGNOSTICS_ENABLED = "pf.cluster.diagnostics.enabled";
    private static final String DIAGNOSTICS_ADDR = "pf.cluster.diagnostics.addr";
    private static final String DIAGNOSTICS_PORT = "pf.cluster.diagnostics.port";
    private static final String THREAD_POOL_MAX_THREADS = "pf.cluster.thread.pool.max.threads";
    private static final String DEFAULT_DIAGNOSTICS_ADDR = "224.0.75.75";
    private static final String DEFAULT_DIAGNOSTICS_PORT = "7500";
    private static final String DEFAULT_DIAGNOSTICS_ENABLED = "false";
    private static final String DEFAULT_THREAD_POOL_MAX_THREADS = "40";
    private static final String COMMA = ",";
    private static final String BIND_ADDRESS_GLOBAL = "GLOBAL";
    private static final String BIND_ADDRESS_SITE_LOCAL = "SITE_LOCAL";
    private static final String BIND_ADDRESS_LINK_LOCAL = "LINK_LOCAL";
    private static final String BIND_ADDRESS_LOOPBACK = "LOOPBACK";
    private static final String BIND_ADDRESS_NON_LOOPBACK = "NON_LOOPBACK";
    private static final String BIND_ADDRESS_MATCH_INTERFACE = "match-interface:";
    private static final String BIND_ADDRESS_MATCH_HOST = "match-host:";
    private static final String BIND_ADDRESS_MATCH_ADDRESS = "match-address:";
    private static final String ISOLATE_CLUSTERS_BY_VERSION = "IsolateClustersByVersion";
    private static final int MIN_BCFIPS_PWD_LENGTH = 22;
    private final ConfigStore configStore = ConfigStoreFarm.getConfig("com.pingidentity.jgroups.ChannelFactory");

    ChannelFactory() {
        this(System.getProperties());
    }

    ChannelFactory(Properties props) {
        this.properties = props;
        this.stackname = this.properties.getProperty(TRANSPORT_PROTOCOL, "udp");
        log.debug((Object)("new ChannelFactory using stack=" + this.stackname));
        try {
            this.jChannel = new JChannel((InputStream)new ByteArrayInputStream(this.getStacksXml().getBytes(StandardCharsets.UTF_8)));
            SYM_ENCRYPT symEncrypt = (SYM_ENCRYPT)this.jChannel.getProtocolStack().findProtocol(SYM_ENCRYPT.class);
            if (symEncrypt != null) {
                symEncrypt.secureRandom(SecurityProviderUtil.getSecureRandom());
            }
            try {
                PropertyConverters.Default converter = new PropertyConverters.Default();
                InetAddress addr = (InetAddress)converter.convert(null, InetAddress.class, "bind_addr", this.validatedBindAddress, true, Util.getIpStackType());
                if (addr == null) {
                    throw new RuntimeException("PropertyConverters.Default.convert() returned null");
                }
                String channelName = addr.getHostAddress() + ":" + this.properties.getProperty(BIND_PORT);
                log.debug((Object)("Setting JGroups channel name to " + channelName));
                this.jChannel.setName(channelName);
            }
            catch (Exception e) {
                log.warn((Object)("Error obtaining actual bind address from '" + this.validatedBindAddress + "', using default logical name for node"), (Throwable)e);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleFatalError("Problem creating factory for multiplexed cluster communications", e);
        }
    }

    static synchronized ChannelFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = new ChannelFactory();
        }
        return defaultFactory;
    }

    synchronized void connect(JChannel channel) throws Exception {
        String version;
        Object clusterName = "pf";
        String clusterNameProperty = this.properties.getProperty(CLUSTER_NAME_PROP_NAME);
        if (clusterNameProperty != null) {
            clusterName = clusterNameProperty;
        }
        if (this.isolateClustersByVersion() && (version = PropertyInfo.getPingFederateVersion()) != null) {
            int secondDotIndex = StringUtils.ordinalIndexOf((String)version, (String)".", (int)2);
            if (secondDotIndex != -1) {
                version = version.substring(0, secondDotIndex);
            }
            clusterName = (String)clusterName + "-" + version;
        }
        try {
            channel.connect((String)clusterName);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SecurityException) {
                String msg = "Failed to authenticate to the cluster!  Please check the password value specified for the pf.cluster.auth.pwd property";
                e = new Exception(msg, e);
            }
            throw e;
        }
        ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
        if (config.getBooleanValue("register-channel-with-jmx", true)) {
            try {
                log.debug((Object)"Registering cluster channel with the platform JMX MBean server");
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                JmxConfigurator.registerChannel((JChannel)this.jChannel, (MBeanServer)mbs, (String)"pingfederate.cluster", null, (boolean)true);
            }
            catch (Exception e) {
                log.error((Object)"Unable to register cluster channel with the platform JMX MBean server", (Throwable)e);
            }
        }
    }

    synchronized JChannel getChannel() {
        return this.jChannel;
    }

    String getStacksXml() throws Substituter.UnknownKeyException, IOException {
        String diagnosticsPort;
        String diagnosticsAddress;
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        String confDir = sysDirInfo.getConfigDirectory();
        String stacksXmlFileLocation = confDir + File.separator + this.stackname + ".xml";
        String rawXml = null;
        try {
            rawXml = SimpleFileUtil.readFileToString(new File(stacksXmlFileLocation));
        }
        catch (IOException e) {
            ErrorHandler.handleFatalError("Invalid pf.cluster.transport.protocol: " + this.stackname, e);
        }
        log.debug((Object)("raw xml for " + stacksXmlFileLocation + ": " + rawXml));
        Properties substitutionValuesMap = new Properties();
        substitutionValuesMap.putAll((Map<?, ?>)this.properties);
        String bindAddress = substitutionValuesMap.getProperty(BIND_ADDRESS_PROP_NAME);
        this.validatedBindAddress = ChannelFactory.validateBindAddress(bindAddress);
        String bindDirective = "bind_addr=\"" + this.validatedBindAddress + "\"";
        String portRange = substitutionValuesMap.getProperty(BIND_PORT_RANGE_PROP_NAME);
        portRange = StringUtils.isBlank((String)portRange) ? "0" : portRange;
        substitutionValuesMap.put(BIND_PORT_RANGE_PROP_NAME, portRange);
        String diagnosticsEnabled = substitutionValuesMap.getProperty(DIAGNOSTICS_ENABLED);
        if (StringUtils.isBlank((String)diagnosticsEnabled)) {
            substitutionValuesMap.put(DIAGNOSTICS_ENABLED, DEFAULT_DIAGNOSTICS_ENABLED);
        }
        if (StringUtils.isBlank((String)(diagnosticsAddress = substitutionValuesMap.getProperty(DIAGNOSTICS_ADDR)))) {
            diagnosticsAddress = DEFAULT_DIAGNOSTICS_ADDR;
            substitutionValuesMap.put(DIAGNOSTICS_ADDR, DEFAULT_DIAGNOSTICS_ADDR);
        }
        if (!InetAddresses.isInetAddress((String)diagnosticsAddress)) {
            String message = "Invalid pf.cluster.diagnostics.addr.";
            ErrorHandler.handleFatalError(message, null);
        }
        if (StringUtils.isBlank((String)(diagnosticsPort = substitutionValuesMap.getProperty(DIAGNOSTICS_PORT)))) {
            diagnosticsPort = DEFAULT_DIAGNOSTICS_PORT;
            substitutionValuesMap.put(DIAGNOSTICS_PORT, DEFAULT_DIAGNOSTICS_PORT);
        }
        this.validPortParameter(DIAGNOSTICS_PORT, diagnosticsPort);
        String theadPoolMaxThreads = substitutionValuesMap.getProperty(THREAD_POOL_MAX_THREADS);
        if (StringUtils.isBlank((String)theadPoolMaxThreads)) {
            theadPoolMaxThreads = DEFAULT_THREAD_POOL_MAX_THREADS;
        }
        substitutionValuesMap.put(THREAD_POOL_MAX_THREADS, theadPoolMaxThreads);
        substitutionValuesMap.put(BIND_ADDRESS_DIRECTIVE_KEY, bindDirective);
        substitutionValuesMap.put(BIND_ADDRESS_PROP_NAME, this.validatedBindAddress);
        this.validPortParameter(BIND_PORT, substitutionValuesMap.getProperty(BIND_PORT));
        String fdSockPort = substitutionValuesMap.getProperty(FD_SOCK_BIND_PORT_NAME);
        this.validPortParameter(FD_SOCK_BIND_PORT_NAME, substitutionValuesMap.getProperty(FD_SOCK_BIND_PORT_NAME));
        fdSockPort = StringUtils.isBlank((String)fdSockPort) ? "0" : fdSockPort;
        substitutionValuesMap.put(FD_SOCK_BIND_PORT_NAME, fdSockPort);
        String encProp = substitutionValuesMap.getProperty(ENCRYPT_PROP_NAME);
        boolean doEncryption = Boolean.parseBoolean(encProp);
        String pwd = substitutionValuesMap.getProperty(AUTH_PROP_NAME);
        if (StringUtils.isBlank((String)pwd)) {
            if (doEncryption) {
                ErrorHandler.handleFatalError("When encrypting the JGroups clustering network traffic, you must provide a strong key via the pf.cluster.auth.pwd property.", null);
            } else {
                log.warn((Object)"Cluster encryption disabled and no value specified for the pf.cluster.auth.pwd property. Cluster encryption and the use of a strong authentication key is highly recommended.");
            }
        } else if (!doEncryption) {
            log.info((Object)"A value was provided for pf.cluster.auth.pwd but pf.cluster.encrypt is false. Encryption will still be enabled to strengthen access controls.");
            doEncryption = true;
        }
        substitutionValuesMap.put(AUTH_PROP_NAME, "unused");
        String encryptTags = "";
        if (doEncryption) {
            encryptTags = ENCRYPT.getTags();
            Password password = new Password(pwd);
            String deobfuscated = password.getStrValue();
            if (PropertyInfo.isBCFIPSMode() && deobfuscated.length() < 22) {
                ErrorHandler.handleFatalError("In BCFIPS mode with encryption enabled, the pf.cluster.auth.pwd property must be at least 22 characters.", null);
            }
            ENCRYPT.generateKeyStore(deobfuscated);
        }
        substitutionValuesMap.put(ENCRYPT_TAG_KEY, encryptTags);
        String initHosts = substitutionValuesMap.getProperty(INIT_HOSTS_PROP_NAME, "");
        String processedInitHosts = ChannelFactory.preProcessInitialHosts(initHosts);
        substitutionValuesMap.setProperty(INIT_HOSTS_PROP_NAME, processedInitHosts);
        if ("udp".equalsIgnoreCase(this.stackname)) {
            this.validPortParameter(MCAST_PORT, substitutionValuesMap.getProperty(MCAST_PORT));
        }
        DiscoveryProtocol discoveryProtocol = new DiscoveryProtocol();
        String discoveryProtocolTag = discoveryProtocol.getDiscoveryProtocolTag(substitutionValuesMap);
        substitutionValuesMap.put(DISCOVERY_TAG_KEY, discoveryProtocolTag);
        String finalXml = Substituter.substituteValues(rawXml, substitutionValuesMap);
        return ChannelFactory.deobfuscatePasswords(finalXml);
    }

    static String deobfuscatePasswords(String xml) {
        String OBF_PATTERN = "(?<=[\"'])OBF:[^\"']+";
        Pattern pattern = Pattern.compile("(?<=[\"'])OBF:[^\"']+");
        StringBuilder result = new StringBuilder();
        Matcher matcher = pattern.matcher(xml);
        int prevEnd = 0;
        while (matcher.find()) {
            result.append(xml.substring(prevEnd, matcher.start()));
            String obfuscated = xml.substring(matcher.start(), matcher.end());
            Password password = new Password(obfuscated);
            if (password.getStrValue() != null) {
                result.append(password.getStrValue());
            } else {
                result.append(obfuscated);
            }
            prevEnd = matcher.end();
        }
        result.append(xml.substring(prevEnd));
        return result.toString();
    }

    static String preProcessInitialHosts(String initialHosts) {
        ArrayList<String> validHosts = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(initialHosts, COMMA);
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            try {
                token = tokenizer.nextToken().trim();
                String host = token.substring(0, token.indexOf(91));
                host = host.trim();
                int port = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                new IpAddress(host, port);
                validHosts.add(token);
            }
            catch (Exception e) {
                log.warn((Object)("Not using invalid host (" + token + ") specified in pf.cluster.tcp.discovery.initial.hosts: " + e));
            }
        }
        StringBuilder result = new StringBuilder();
        Iterator iterator = validHosts.iterator();
        while (iterator.hasNext()) {
            String host = (String)iterator.next();
            result.append(host);
            if (!iterator.hasNext()) continue;
            result.append(COMMA);
        }
        log.info((Object)("pf.cluster.tcp.discovery.initial.hosts processed from '" + initialHosts + "' to '" + result + "'"));
        return result.toString();
    }

    static String validateBindAddress(String bindAddr) {
        if (StringUtils.isBlank((String)bindAddr)) {
            bindAddr = BIND_ADDRESS_NON_LOOPBACK;
        }
        switch (bindAddr = bindAddr.trim()) {
            case "GLOBAL": 
            case "SITE_LOCAL": 
            case "LINK_LOCAL": 
            case "LOOPBACK": 
            case "NON_LOOPBACK": {
                return bindAddr;
            }
        }
        if (bindAddr.startsWith(BIND_ADDRESS_MATCH_ADDRESS) || bindAddr.startsWith(BIND_ADDRESS_MATCH_HOST) || bindAddr.startsWith(BIND_ADDRESS_MATCH_INTERFACE)) {
            return bindAddr;
        }
        try {
            SystemParameterValidator.validateLocalIPAddress(bindAddr);
        }
        catch (Exception e) {
            String message = "Invalid pf.cluster.bind.address.";
            ErrorHandler.handleFatalError(message, e);
        }
        if ("0.0.0.0".equals(bindAddr) || "::".equals(bindAddr)) {
            String message = "Invalid pf.cluster.bind.address.";
            ErrorHandler.handleFatalError(message, null);
        }
        return bindAddr;
    }

    private void validPortParameter(String paramName, String portValue) {
        try {
            SystemParameterValidator.validatePort(portValue);
        }
        catch (InvalidSystemParameterException e) {
            ErrorHandler.handleFatalError("Invalid " + paramName, e);
        }
    }

    private boolean isolateClustersByVersion() {
        return this.configStore.getBooleanValue(ISOLATE_CLUSTERS_BY_VERSION, true);
    }
}

