/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.View;
import org.jgroups.blocks.ReplicatedHashMap;

class DistributedMapLogNotifListener
implements ReplicatedHashMap.Notification {
    private Log log = LogFactory.getLog(this.getClass());

    DistributedMapLogNotifListener() {
    }

    public void entrySet(Object key, Object value) {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            Object displayVal = value;
            if (displayVal instanceof byte[]) {
                displayVal = value + " w/ " + ((byte[])value).length + " bytes";
            }
            msg.append("entrySet(").append(key).append(", ").append(displayVal).append(")");
            this.log.debug((Object)msg);
        }
    }

    public void viewChange(View view, List newMbrs, List oldMbrs) {
        if (this.log.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("viewChange(view:").append(view);
            msg.append(", joining: ").append(newMbrs);
            msg.append(", leaving: ").append(oldMbrs).append(")");
            this.log.info((Object)msg);
        }
    }

    public void entryRemoved(Object key) {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("entryRemoved(").append(key).append(")");
            this.log.debug((Object)msg);
        }
    }

    public void contentsSet(Map newContents) {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("contentsSet(").append(newContents).append(")");
            this.log.debug((Object)msg);
        }
    }

    public void contentsCleared() {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("contentsCleared()");
            this.log.debug((Object)msg);
        }
    }
}

