/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.service.impl.grouprpc.QuietRpc;

public class MuxInvocationHandler
implements InvocationHandler {
    private Map<Class, Object> targets;
    private static final Log log = LogFactory.getLog(MuxInvocationHandler.class);

    MuxInvocationHandler(Map<Class, Object> targets) {
        this.targets = targets;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object target = this.targets.get(method.getDeclaringClass());
        if (target == null) {
            log.warn((Object)("unable to invoke method because target is null " + this.invokeSummary(method, target)));
            return null;
        }
        try {
            Object o = method.invoke(target, args);
            if (method.isAnnotationPresent(QuietRpc.class)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("invocation of " + this.invokeSummary(method, target)));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("invocation of " + this.invokeSummary(method, target)));
            }
            return o;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.error((Object)("problem during invocation of " + this.invokeSummary(method, target)), e);
            throw e;
        }
    }

    private StringBuilder invokeSummary(Method method, Object target) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName()).append(" on ").append(target);
        return sb;
    }
}

