/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups;

import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.util.UUID;

public class NodeAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient UUID uuid;
    private String serializedAddress;

    public NodeAddress(Address address) {
        if (!(address instanceof UUID)) {
            throw new IllegalArgumentException("address must be instance of JGroups UUID");
        }
        this.uuid = (UUID)address;
        this.serializedAddress = this.uuid.toStringLong();
    }

    public Address getAddress() {
        if (this.uuid == null) {
            this.uuid = UUID.fromString((String)this.serializedAddress);
        }
        return this.uuid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeAddress)) {
            return false;
        }
        NodeAddress other = (NodeAddress)obj;
        return this.getAddress().equals(other.getAddress());
    }

    public int hashCode() {
        return this.getAddress().hashCode();
    }

    public String toString() {
        return this.getAddress().toString();
    }
}

