/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jgroups.protocols;

import com.pingidentity.jgroups.protocols.IntegrityHeader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Mac;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.EncryptHeader;
import org.jgroups.protocols.SYM_ENCRYPT;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Adds an HMAC-based integrity check to messages")
public class INTEGRITY
extends Protocol {
    private static short MAGIC_ID = (short)26059;
    @Property(description="Cryptographic service provider for message signing. Leave as null to use the default provider.")
    protected String provider;
    @Property(description="HMAC algorithm to be used for message signing")
    protected String hmac_algorithm = "HmacSHA256";
    @Property(description="By default, the full HMAC is included as a message header. To instead use a truncated HMAC, specify the desired length of the byte array in this field.")
    protected int hmac_length = -1;
    @Property(description="File on classpath that contains keystore repository")
    protected String keystore_name;
    @Property(description="The type of the keystore")
    protected String keystore_type = "JCEKS";
    @Property(description="Password used to unlock the keystore", exposeAsManagedAttribute=false)
    protected String store_password;
    @Property(description="Password for recovering the key", exposeAsManagedAttribute=false)
    protected String key_password;
    @Property(name="alias", description="Alias used for recovering the key", exposeAsManagedAttribute=false)
    protected String alias;
    protected Key secret_key;
    protected Address local_addr;
    protected SYM_ENCRYPT sym_encrypt;

    public INTEGRITY keystoreName(String n) {
        this.keystore_name = n;
        return this;
    }

    public INTEGRITY alias(String a) {
        this.alias = a;
        return this;
    }

    public INTEGRITY storePassword(String pwd) {
        this.store_password = pwd;
        return this;
    }

    public void init() throws Exception {
        this.sym_encrypt = (SYM_ENCRYPT)this.stack.findProtocol(SYM_ENCRYPT.class);
        if (this.sym_encrypt == null) {
            this.log.debug("SYM_ENCRYPT not found in protocol stack");
        }
        this.readSecretKeyFromKeystore();
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
        }
        return this.down_prot.down(evt);
    }

    public Object down(Message msg) {
        try {
            byte[] signature = this.getSignature(msg);
            msg.putHeader(this.id, (Header)new IntegrityHeader(signature));
            return this.down_prot.down(msg);
        }
        catch (Exception e) {
            this.log.warn("%s: exception occurred adding INTEGRITY header to message", new Object[]{this.local_addr, e});
            return null;
        }
    }

    public Object up(Message msg) {
        try {
            if (!this.validateSignature(msg)) {
                return null;
            }
            return this.up_prot.up(msg);
        }
        catch (Exception e) {
            this.log.warn("%s: exception occurred validating INTEGRITY header on message", new Object[]{this.local_addr, e});
            return null;
        }
    }

    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            try {
                if (this.validateSignature(msg)) continue;
                batch.remove(msg);
            }
            catch (Exception e) {
                this.log.warn("%s: exception occurred validating INTEGRITY header on message", new Object[]{this.local_addr, e});
                batch.remove(msg);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected byte[] getSignature(Message msg) throws Exception {
        byte[] iv;
        EncryptHeader encryptHeader;
        Mac hmac = this.provider != null ? Mac.getInstance(this.hmac_algorithm, this.provider) : Mac.getInstance(this.hmac_algorithm);
        hmac.init(this.secret_key);
        if (this.sym_encrypt != null && (encryptHeader = (EncryptHeader)msg.getHeader(this.sym_encrypt.getId())) != null && (iv = encryptHeader.iv()) != null) {
            hmac.update(iv);
        }
        if (msg.getRawBuffer() != null) {
            hmac.update(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
        }
        byte[] hmacBytes = hmac.doFinal();
        if (this.hmac_length <= 0) {
            return hmacBytes;
        }
        return Arrays.copyOf(hmacBytes, this.hmac_length);
    }

    protected boolean validateSignature(Message msg) throws Exception {
        IntegrityHeader integrityHeader = (IntegrityHeader)msg.getHeader(this.id);
        if (integrityHeader == null) {
            this.log.error("%s: message from %s missing IntegrityHeader, dropping it", new Object[]{this.local_addr, msg.src()});
            return false;
        }
        if (integrityHeader.hmac() == null) {
            this.log.error("%s: IntegrityHeader from %s is missing hmac, dropping message", new Object[]{this.local_addr, msg.src()});
            return false;
        }
        byte[] signature = this.getSignature(msg);
        boolean result = MessageDigest.isEqual(signature, integrityHeader.hmac());
        if (!result) {
            this.log.error("%s: message from %s has invalid signature, dropping it", new Object[]{this.local_addr, msg.src()});
        }
        return result;
    }

    protected void readSecretKeyFromKeystore() throws Exception {
        KeyStore store = KeyStore.getInstance(this.keystore_type != null ? this.keystore_type : KeyStore.getDefaultType());
        if (this.keystore_name == null) {
            throw new Exception("A value must be specified for keystore_name");
        }
        if (this.alias == null) {
            throw new Exception("A value must be specified for alias");
        }
        if (this.store_password == null) {
            throw new Exception("A value must be specified for store_password");
        }
        if (this.key_password == null) {
            this.key_password = this.store_password;
            this.log.debug("key_password used is same as store_password");
        }
        try (InputStream inputStream = this.getKeyStoreSource();){
            store.load(inputStream, this.store_password.toCharArray());
        }
        if (!store.entryInstanceOf(this.alias, KeyStore.SecretKeyEntry.class)) {
            throw new Exception("Key '" + this.alias + "' from keystore " + this.keystore_name + " is not a secret key");
        }
        KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)store.getEntry(this.alias, new KeyStore.PasswordProtection(this.key_password.toCharArray()));
        this.secret_key = entry.getSecretKey();
    }

    protected InputStream getKeyStoreSource() throws FileNotFoundException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keystore_name);
        return inputStream == null ? new FileInputStream(this.keystore_name) : inputStream;
    }

    static {
        ClassConfigurator.addProtocol((short)MAGIC_ID, INTEGRITY.class);
        ClassConfigurator.add((short)30926, IntegrityHeader.class);
    }
}

