/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jmx;

import com.pingidentity.configservice.Reloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.jmx.NoAuthPFJMXAuthenticator;
import com.pingidentity.jmx.PFJMXAuthenticator;
import com.pingidentity.jmx.mbeans.Counter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigStoreLocation;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AppAuthMap;
import org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl;
import org.sourceid.saml20.domain.mgmt.impl.RuntimeSslServerKeyManager;
import org.sourceid.util.reporting.TransactionCounter;

public class JmxBootstrapper
implements Reloadable {
    private ConfigStore config = ConfigStoreFarm.getConfig(ConfigStoreLocation.CONF, "jmx-remote-config");
    private Log log = LogFactory.getLog(this.getClass());
    private static String ACCESS_FILE = "/jmx.remote.access";
    private static final String REGISTRY_PORT_KEY = "rmi.registry.port";
    private static final String REGISTRY_SSL_KEY = "rmi.registry.ssl";
    private static final String RMI_PORT_KEY = "jmx.rmi.port";
    private static final String JMX_VIA_SSL_KEY = "jmx.rmi.ssl";
    private static final String JMX_REQ_AUTH_KEY = "jmxremote.auth";
    private static final String JMXRMI = "jmxrmi";
    private static JmxBootstrapper instance = new JmxBootstrapper();
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private RMIJRMPServerImpl rmiJrmpServer;
    private JMXConnectorServer jmxConnectorServer;
    private Registry registry;
    private boolean isActive;
    private int registryPort = -1;
    private boolean registryIsSSL;
    private boolean requireAuth;
    private boolean rmiViaSSL;
    private int rmiPort = -1;
    private String bindAddress = System.getProperty("pf.monitor.bind.address");

    private JmxBootstrapper() {
        System.setProperty("java.rmi.server.randomIDs", "true");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.initJmxServer();
        this.registerLegacyTransactionCounters();
        ConfigStoreFarm.registerForReloadEvents(this);
    }

    public static JmxBootstrapper getJmxBootstrapper() {
        return instance;
    }

    @Override
    public void reload() {
        this.initJmxServer();
    }

    private synchronized void initJmxServer() {
        boolean jmxEnabled;
        AppAuthMapManagerImpl appAuthMgr = new AppAuthMapManagerImpl();
        AppAuthMap jmxAuthMap = appAuthMgr.getJmxMap();
        boolean newIsActive = jmxAuthMap.isActive();
        boolean activeSame = newIsActive == this.isActive;
        this.isActive = newIsActive;
        int newRegistryPort = this.config.getIntValue(REGISTRY_PORT_KEY, 0);
        boolean newRegistryIsSSL = this.config.getBooleanValue(REGISTRY_SSL_KEY, false);
        boolean registrySame = newRegistryPort == this.registryPort && newRegistryIsSSL == this.registryIsSSL && activeSame;
        this.registryPort = newRegistryPort;
        this.registryIsSSL = newRegistryIsSSL;
        if (!registrySame) {
            this.unexportRegistry();
        }
        boolean newRequireAuth = this.config.getBooleanValue(JMX_REQ_AUTH_KEY, true);
        boolean newRmiViaSSL = this.config.getBooleanValue(JMX_VIA_SSL_KEY, true);
        int newRmiPort = this.config.getIntValue(RMI_PORT_KEY, 0);
        boolean rmiSame = newRequireAuth == this.requireAuth && newRmiViaSSL == this.rmiViaSSL && newRmiPort == this.rmiPort && activeSame;
        this.requireAuth = newRequireAuth;
        this.rmiViaSSL = newRmiViaSSL;
        this.rmiPort = newRmiPort;
        if (!rmiSame) {
            this.stopJmxconnectorServer();
        }
        this.log.info((Object)("isActive=" + this.isActive + " and registry port is " + this.registryPort));
        boolean bl = jmxEnabled = this.registryPort > 0 && this.isActive;
        if (jmxEnabled) {
            try {
                SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                if (!registrySame) {
                    RMIServerSocketFactory ssf = this.getRmiServerSocketFactory(this.registryIsSSL);
                    this.registry = LocateRegistry.createRegistry(this.registryPort, this.registryIsSSL ? csf : null, ssf);
                    this.log.info((Object)((this.registryIsSSL ? "SSL " : "") + "RMI registry started on " + this.registryPort));
                }
                if (!rmiSame) {
                    this.log.info((Object)("JMX RMI port: " + this.rmiPort));
                    HashMap<String, Object> env = new HashMap<String, Object>();
                    this.log.info((Object)("Authentication required for remote JMX connections: " + this.requireAuth));
                    JMXAuthenticator authenticator = this.requireAuth ? new PFJMXAuthenticator() : new NoAuthPFJMXAuthenticator();
                    env.put("jmx.remote.authenticator", authenticator);
                    SysDirInfo dirInfo = GlobalRegistry.getService(SysDirInfo.class);
                    String file = dirInfo.getConfigDirectory() + ACCESS_FILE;
                    this.log.info((Object)("jmx remote access file: " + file));
                    env.put("jmx.remote.x.access.file", file);
                    this.log.info((Object)("Remote JMX connections using SSL: " + this.rmiViaSSL));
                    RMIServerSocketFactory ssf = this.getRmiServerSocketFactory(this.rmiViaSSL);
                    this.rmiJrmpServer = new RMIJRMPServerImpl(this.rmiPort, this.rmiViaSSL ? csf : null, ssf, env);
                    JMXServiceURL jmxSvcUrl = new JMXServiceURL("service:jmx:rmi://" + this.bindAddress);
                    this.jmxConnectorServer = new RMIConnectorServer(jmxSvcUrl, env, this.rmiJrmpServer, this.mbeanServer);
                    this.jmxConnectorServer.start();
                    JMXServiceURL address = this.jmxConnectorServer.getAddress();
                    this.log.info((Object)("Jmx Connector Server started at " + address));
                }
                this.registry.rebind(JMXRMI, this.rmiJrmpServer);
            }
            catch (Exception e) {
                this.log.error((Object)"Unexpected problem starting JMX connector server", (Throwable)e);
            }
        } else {
            this.log.info((Object)"Not starting Jmx Connector Server because rmi.registry.port config field is not set or service not active in application auth.");
        }
    }

    private void unexportRegistry() {
        if (this.registry != null) {
            try {
                this.log.info((Object)"Unexporting rmi registry");
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException e) {
                this.log.error((Object)("Problem unexporting rmi registry: " + e.getMessage()));
            }
        }
    }

    private void stopJmxconnectorServer() {
        if (this.jmxConnectorServer != null) {
            try {
                String connIds = Arrays.toString(this.jmxConnectorServer.getConnectionIds());
                this.log.info((Object)("Stopping jmx connector server - existing connections will be terminated " + connIds));
                this.jmxConnectorServer.stop();
            }
            catch (IOException e) {
                this.log.error((Object)"Problem stopping jmx connector server.", (Throwable)e);
            }
        }
    }

    private void registerLegacyTransactionCounters() {
        String objectNameBase = "pingfederate:type=";
        try {
            for (TransactionCounter transactionCounter : TransactionCounter.values()) {
                Counter counter = new Counter(transactionCounter::getCount);
                ObjectName name = new ObjectName("pingfederate:type=" + transactionCounter.name());
                this.mbeanServer.registerMBean(counter, name);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unexpected error registering legacy transaction counters", (Throwable)e);
        }
    }

    private RMIServerSocketFactory getRmiServerSocketFactory(boolean isSsl) throws NoSuchAlgorithmException, KeyManagementException {
        ServerSocketFactory ssfc;
        if (isSsl) {
            RuntimeSslServerKeyManager serverX509KeyManager = RuntimeSslServerKeyManager.getInstance();
            KeyManager[] keyMgrArray = new KeyManager[]{serverX509KeyManager};
            SSLContext sslc = SSLContext.getInstance("SSL");
            sslc.init(keyMgrArray, null, SecurityProviderUtil.getSecureRandom());
            ssfc = sslc.getServerSocketFactory();
        } else {
            ssfc = ServerSocketFactory.getDefault();
        }
        return new RMIServerSocketFactory(){

            @Override
            public ServerSocket createServerSocket(int port) throws IOException {
                InetAddress inetAddress = InetAddress.getByName(JmxBootstrapper.this.bindAddress);
                ServerSocket serverSocket = ssfc.createServerSocket(port, 50, inetAddress);
                JmxBootstrapper.this.log.info((Object)("RMIServerSocketFactory returning : " + serverSocket));
                return serverSocket;
            }
        };
    }
}

