/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.jmx;

import com.pingidentity.common.security.LockingService;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.AppAuthMap;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl;

public class PFJMXAuthenticator
implements JMXAuthenticator {
    private static final Log log = LogFactory.getLog(PFJMXAuthenticator.class);
    static final JMXPrincipal DEFAULT_PRINCIPAL = new JMXPrincipal("default-jmx-principal");
    private final AppAuthMapManagerImpl appAuthMgr = new AppAuthMapManagerImpl();
    private final LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(this.getClass().getSimpleName());

    @Override
    public Subject authenticate(Object credentials) {
        Subject subject = new Subject();
        if (credentials instanceof String[]) {
            String[] creds = (String[])credentials;
            String uname = creds[0];
            String pwd = creds[1];
            if (this.accountLockingService.isLocked(uname)) {
                log.info((Object)("authentication failed, account locked: " + uname));
            } else {
                AppAuthMap appAuthMap = this.appAuthMgr.getJmxMap();
                if (appAuthMap.isActive() && appAuthMap.authenticate(uname, pwd)) {
                    log.info((Object)("successful authentication of remote jmx connection: '" + uname + "'"));
                    subject.getPrincipals().add(DEFAULT_PRINCIPAL);
                    subject.getPrincipals().add(new JMXPrincipal(uname));
                    this.accountLockingService.clearFailedLogins(uname);
                } else {
                    this.accountLockingService.logFailedLogin(uname);
                    if (this.accountLockingService.isLocked(uname)) {
                        log.info((Object)("authentication failed, account locked: " + uname));
                    } else {
                        log.info((Object)("failed authentication of remote jmx connection: '" + uname + "'"));
                    }
                }
            }
        } else {
            String credsMsg = credentials == null ? null : credentials.getClass().toString();
            log.info((Object)("remote jmx connection presented credentials that are not a String array: " + credsMsg));
        }
        return subject;
    }
}

