/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.locale;

import com.google.common.io.Files;
import com.pingidentity.configservice.SysInfoHelper;
import com.pingidentity.locale.LocaleFiles;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.SpaceDelimitedStringUtil;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.wrapper.AuthnApiRequestProxy;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.servlet.reqparam.HttpServletReqProxy;

public abstract class LocaleUtil {
    public static final String RSC_BUNDLE_NAME_PF_MESSAGES = "pingfederate-messages";
    public static final String RSC_BUNDLE_NAME_PF_EMAIL_MESSAGES = "pingfederate-email-messages";
    public static final String RSC_BUNDLE_NAME_PF_SMS_MESSAGES = "pingfederate-sms-messages";
    private static final Log log = LogFactory.getLog(LocaleUtil.class);
    private static List<Locale> supportedLocaleCache = new ArrayList<Locale>();
    private static boolean cacheSupportedLanguages = ConfigStoreFarm.getConfig("locale-options").getBooleanValue("cache-language-pack-messages", true);

    public static HttpServletRequestWrapper createLocaleWrappedRequest(HttpServletRequest request, String localeStrings) {
        if (request instanceof AuthnApiRequestProxy) {
            return new LocaleOverrideAuthnApiRequest(request, localeStrings);
        }
        return new LocaleOverrideHttpServletRequest(request, localeStrings);
    }

    public static Locale getUserLocale(HttpServletRequest request) {
        Locale preferredLocal = Locale.ENGLISH;
        if (request != null) {
            Locale overrideLocale = MgmtFactory.getLocaleOverrideService().getLocale(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Locale Override: " + (Serializable)(overrideLocale != null ? overrideLocale : "none")));
            }
            if (overrideLocale != null && LocaleUtil.isLocaleSupported(overrideLocale)) {
                preferredLocal = overrideLocale;
            } else {
                Enumeration locales = request.getLocales();
                if (locales != null) {
                    while (locales.hasMoreElements()) {
                        Locale nextLocale = (Locale)locales.nextElement();
                        if (!LocaleUtil.isLocaleSupported(nextLocale)) continue;
                        preferredLocal = nextLocale;
                        break;
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"No Locales detected");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User's Locale: " + preferredLocal));
        }
        return preferredLocal;
    }

    public static String getLocalizedString(HttpServletRequest request, String resourceBundleBaseName, String key, String[] substitutions) {
        LanguagePackMessages lpm = new LanguagePackMessages(resourceBundleBaseName, LocaleUtil.getUserLocale(request));
        return lpm.getMessage(key, substitutions);
    }

    public static String getLocalizedString(Locale locale, String resourceBundleBaseName, String key, String[] substitutions) {
        LanguagePackMessages lpm = new LanguagePackMessages(resourceBundleBaseName, locale);
        return lpm.getMessage(key, substitutions);
    }

    public static LanguagePackMessages getLanguagePackMessagesForHtmlTemplates(HttpServletRequest request) {
        return LocaleUtil.getLanguagePackMessagesForHtmlTemplates(LocaleUtil.getUserLocale(request));
    }

    public static LanguagePackMessages getLanguagePackMessagesForHtmlTemplates(Locale locale) {
        return new LanguagePackMessages(RSC_BUNDLE_NAME_PF_MESSAGES, locale);
    }

    public static LanguagePackMessages getLanguagePackMessagesForEmailTemplates(Locale locale) {
        return new LanguagePackMessages(RSC_BUNDLE_NAME_PF_EMAIL_MESSAGES, locale);
    }

    public static LanguagePackMessages getLanguagePackMessagesForSmsTemplates(Locale locale) {
        return new LanguagePackMessages(RSC_BUNDLE_NAME_PF_SMS_MESSAGES, locale);
    }

    protected static void setCacheSupportedLanguages(boolean cache) {
        cacheSupportedLanguages = cache;
    }

    private static boolean isLocaleSupported(Locale locale) {
        boolean localeSupported;
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            localeSupported = true;
        } else if (supportedLocaleCache.contains(locale)) {
            localeSupported = true;
        } else {
            File file = new File(SysInfoHelper.getSysDirInfo().getLanguagePacksDir());
            File[] supportedLanguagePacksForLocale = file.listFiles(new LanguagePackFilenameFilter(locale));
            boolean bl = localeSupported = supportedLanguagePacksForLocale != null && supportedLanguagePacksForLocale.length > 0;
            if (localeSupported && cacheSupportedLanguages) {
                supportedLocaleCache.add(locale);
            }
            if (!localeSupported && log.isDebugEnabled()) {
                log.debug((Object)("Language not supported: " + locale));
            }
        }
        return localeSupported;
    }

    private static class LanguagePackFilenameFilter
    implements FilenameFilter {
        private Locale locale;

        public LanguagePackFilenameFilter(Locale locale) {
            this.locale = locale;
        }

        @Override
        public boolean accept(File dir, String name) {
            LocaleFiles[] localeFiles = LocaleFiles.values();
            if (localeFiles != null) {
                for (LocaleFiles localeFile : localeFiles) {
                    String extension = "." + FilenameUtils.getExtension((String)localeFile.getName());
                    String fileName = Files.getNameWithoutExtension((String)localeFile.getName());
                    if (!name.equals(fileName + "_" + this.locale.getLanguage() + extension) && (!StringUtils.isNotBlank((String)this.locale.getCountry()) || !name.equals(fileName + "_" + this.locale.getLanguage() + "_" + this.locale.getCountry() + extension)) && (!StringUtils.isNotBlank((String)this.locale.getVariant()) || !name.equals(fileName + "_" + this.locale.getLanguage() + "_" + this.locale.getCountry() + "_" + this.locale.getVariant() + extension))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class LocaleHolder {
        private final List<Locale> locales = new ArrayList<Locale>();

        public LocaleHolder(Enumeration<Locale> requestLocales, String localeStrings) {
            for (String localString : SpaceDelimitedStringUtil.fromString((String)localeStrings)) {
                Locale locale = Locale.forLanguageTag(localString);
                this.locales.add(locale);
            }
            while (requestLocales.hasMoreElements()) {
                Locale locale = requestLocales.nextElement();
                if (this.locales.contains(locale)) continue;
                this.locales.add(locale);
            }
        }

        public Enumeration<Locale> getLocales() {
            return Collections.enumeration(this.locales);
        }

        public Locale getLocale() {
            return this.getLocales().nextElement();
        }
    }

    public static class LocaleOverrideAuthnApiRequest
    extends AuthnApiRequestProxy {
        private final LocaleHolder localeHolder;

        private LocaleOverrideAuthnApiRequest(HttpServletRequest request, String localeStrings) {
            super(request);
            this.localeHolder = new LocaleHolder(super.getLocales(), localeStrings);
        }

        public Enumeration<Locale> getLocales() {
            return this.localeHolder.getLocales();
        }

        public Locale getLocale() {
            return this.localeHolder.getLocale();
        }
    }

    public static class LocaleOverrideHttpServletRequest
    extends HttpServletReqProxy {
        private final LocaleHolder localeHolder;

        private LocaleOverrideHttpServletRequest(HttpServletRequest request, String localeStrings) {
            super(request);
            this.localeHolder = new LocaleHolder(super.getLocales(), localeStrings);
        }

        public Enumeration<Locale> getLocales() {
            return this.localeHolder.getLocales();
        }

        public Locale getLocale() {
            return this.localeHolder.getLocale();
        }
    }
}

