/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.localidentity.fieldtypes.HiddenField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FieldConfig
implements Serializable {
    private static final long serialVersionUID = 1231284L;
    private List<LocalIdentityField<?>> fields;
    private boolean maskAllOgnlFields = false;
    private Boolean stripSpaceFromUniqueField;

    public FieldConfig() {
        this.fields = new ArrayList();
    }

    public FieldConfig(List<LocalIdentityField<?>> fields) {
        this.fields = fields;
    }

    public boolean isMaskAllOgnlFields() {
        return this.maskAllOgnlFields;
    }

    public void setMaskAllOgnlFields(boolean maskAllOgnlFields) {
        this.maskAllOgnlFields = maskAllOgnlFields;
    }

    public boolean isStripSpaceFromUniqueField() {
        if (this.stripSpaceFromUniqueField == null) {
            return false;
        }
        return this.stripSpaceFromUniqueField;
    }

    public void setStripSpaceFromUniqueField(Boolean stripSpaceFromUniqueField) {
        this.stripSpaceFromUniqueField = stripSpaceFromUniqueField;
    }

    public void setFieldList(List<LocalIdentityField<?>> localIdentityFields) {
        this.fields = localIdentityFields;
    }

    public List<LocalIdentityField<?>> getListOfAllFields() {
        return this.getListOfAllFields(t -> true);
    }

    private List<LocalIdentityField<?>> getListOfAllFields(Predicate<? super LocalIdentityField> predicate) {
        if (this.fields.isEmpty()) {
            return Collections.emptyList();
        }
        return this.fields.stream().filter(predicate).collect(Collectors.toList());
    }

    public List<String> getListOfProfileFieldIds() {
        return this.getFilteredProfileFields().stream().map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    public List<String> getListOfRegistrationFieldIds() {
        return this.getFilteredRegistrationFields().stream().map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    public List<String> getListOfFieldIds() {
        return this.getListOfAllFields().stream().map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    public LocalIdentityField<?> getUniqueIdField() {
        List<LocalIdentityField<?>> field = this.getListOfAllFields(LocalIdentityField::isUniqueIdField);
        return field.get(0);
    }

    public List<LocalIdentityField<?>> getFilteredRegistrationFields() {
        return this.getListOfAllFields(t -> t.getData().isRegistrationPageField() && !(t instanceof HiddenField));
    }

    public List<LocalIdentityField<?>> getFilteredProfileFields() {
        return this.getListOfAllFields(t -> t.getData().isProfilePageField() && !(t instanceof HiddenField));
    }

    public List<LocalIdentityField<?>> getListOfHiddenProfileFields() {
        return this.getListOfAllFields(field -> field.getData().isProfilePageField() && field instanceof HiddenField);
    }

    public List<LocalIdentityField<?>> getListOfHiddenRegistrationFields() {
        return this.getListOfAllFields(field -> field.getData().isRegistrationPageField() && field instanceof HiddenField);
    }
}

