/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.localidentity.ConnectedIdentity;
import com.pingidentity.localidentity.DataStoreAttribute;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.attrupdates.AuthSourceAttributes;
import com.pingidentity.localidentity.authsource.LocalAccountAuthSource;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class LocalIdentityLdapDTO
implements LocalIdentityDTO<DN> {
    private static final long serialVersionUID = 12378422L;
    private static final Log log = LogFactory.getLog(LocalIdentityLdapDTO.class);
    private final Collection<Attribute> ldapAttributes;
    private final DN dn;
    private final List<ConnectedIdentity> connectedIdentities;
    private final Map<String, AuthSourceAttributes> connectedIdentityAttributes;
    private final LocalIdentityProfile profile;
    private final boolean hasPassword;

    public LocalIdentityLdapDTO(Entry entry, LocalIdentityProfile profile, String connectedIdentityAttributeName, String connectedIdentityAttributeStorageName, boolean hasPassword) {
        DN tempDn;
        this.profile = profile;
        try {
            tempDn = entry.getParsedDN();
        }
        catch (LDAPException e) {
            log.error((Object)("Unable to parse dn for local identity due to " + e.getMessage()));
            tempDn = null;
        }
        this.dn = tempDn;
        this.ldapAttributes = entry.getAttributes();
        this.connectedIdentities = this.parseConnectedIdentities(entry, connectedIdentityAttributeName);
        this.connectedIdentityAttributes = this.parseConnectedIdentityAttributes(entry, connectedIdentityAttributeStorageName);
        this.hasPassword = hasPassword;
    }

    @Override
    public Map<String, Object> getAttributesForMapping() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, DataStoreAttribute> dataStoreMapping = this.profile.getDataStoreConfig().getDataStoreMapping();
        for (Map.Entry<String, DataStoreAttribute> entry : dataStoreMapping.entrySet()) {
            Attribute matchingAttribute = this.findAttribute(entry.getValue().getName());
            if (matchingAttribute == null) continue;
            AttributeValue value = AttrValueSupport.make(Arrays.asList(matchingAttribute.getValues()));
            attributes.put(entry.getKey(), value);
        }
        return attributes;
    }

    @Override
    public Map<String, String[]> getAttributes() {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        Map<String, DataStoreAttribute> dataStoreMapping = this.profile.getDataStoreConfig().getDataStoreMapping();
        for (Map.Entry<String, DataStoreAttribute> entry : dataStoreMapping.entrySet()) {
            Attribute matchingAttribute = this.findAttribute(entry.getValue().getName());
            String[] value = null;
            if (matchingAttribute != null) {
                value = matchingAttribute.getValues();
            }
            attributes.put(entry.getKey(), value);
        }
        return attributes;
    }

    public Collection<Attribute> getLdapAttributes() {
        return this.ldapAttributes;
    }

    @Override
    public List<ConnectedIdentity> getConnectedIdentities() {
        return this.connectedIdentities;
    }

    @Override
    public Map<String, AuthSourceAttributes> getConnectedIdentityAttributes() {
        return this.connectedIdentityAttributes;
    }

    @Override
    public DN getIdentifier() {
        return this.dn;
    }

    @Override
    public boolean hasPassword() {
        return this.hasPassword;
    }

    @Override
    public boolean hasLocalIdentity() {
        return this.connectedIdentities.stream().anyMatch(ci -> ci.getAuthSourceId().equals(LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE.getId()));
    }

    private Attribute findAttribute(String name) {
        return this.ldapAttributes.stream().filter(attribute -> attribute.getName().equals(name)).findFirst().orElse(null);
    }

    private List<ConnectedIdentity> parseConnectedIdentities(Entry entry, String connectedIdentityAttributeName) {
        LinkedList<ConnectedIdentity> connectedIdentities = new LinkedList<ConnectedIdentity>();
        Attribute connectedAttr = entry.getAttribute(connectedIdentityAttributeName);
        if (connectedAttr != null) {
            for (String connectedIdentityString : connectedAttr.getValues()) {
                connectedIdentities.add(new ConnectedIdentity(connectedIdentityString));
            }
        }
        return connectedIdentities;
    }

    private Map<String, AuthSourceAttributes> parseConnectedIdentityAttributes(Entry entry, String connectedIdentityAttributeStorageName) {
        HashMap<String, AuthSourceAttributes> authSourceAttributes = new HashMap<String, AuthSourceAttributes>();
        Attribute authSourceAttr = entry.getAttribute(connectedIdentityAttributeStorageName);
        if (authSourceAttr != null) {
            for (String authSourceAttrsJson : authSourceAttr.getValues()) {
                try {
                    AuthSourceAttributes attributes = AuthSourceAttributes.fromJson(authSourceAttrsJson);
                    authSourceAttributes.put(attributes.getAuthSourceId(), attributes);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unable to parse JSON.", (Throwable)e);
                    }
                    log.warn((Object)("Unable to parse third-party attributes JSON for user '" + this.dn + "' due to: " + e.getMessage() + ". If attribute updates are enabled for this third-party, the updates will not occur."));
                }
            }
        }
        return authSourceAttributes;
    }
}

