/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.EmailVerificationConfig;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.ProfileConfig;
import com.pingidentity.localidentity.RegistrationConfig;
import com.pingidentity.localidentity.authsource.LocalAccountAuthSource;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.unboundid.ldap.sdk.DN;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityProfile
implements Serializable {
    public static final String PROFILE_MGMT_DN_HANDOFF = "PROFILE_USER_DN_HANDOFF";
    public static final String PROFILE_MGMT_SESSION_ATTRIBUTES = "PROFILE_MGMT_SESSION_ATTRS";
    public static final String PREVIOUS_REQUESTED_ACTION = "LOCAL_IDENTITY_PREVIOUS_REQUESTED_ACTION";
    public static final String REGISTRATION_ACTION_NAME = "identity.registration";
    public static final String LDAP_PARAM_NAME_CREATE_PATTERN = "create_pattern";
    public static final String LDAP_PARAM_NAME_OBJECT_CLASS = "object_class";
    public static final String LDAP_PARAM_NAME_AUXILIARY_OBJECT_CLASSES = "auxiliary_object_classes";
    private static final long serialVersionUID = 12941923L;
    private String id;
    private String name;
    private boolean isRegistrationEnabled;
    private boolean isProfileEnabled;
    private List<LocalIdentityAuthSource> authSources = new ArrayList<LocalIdentityAuthSource>();
    private String contractId;
    private ProfileConfig profileConfig;
    private FieldConfig fields;
    private EmailVerificationConfig emailOwnershipVerificationConfig;
    private RegistrationConfig registrationConfig;
    private DataStoreConfig dataStoreConfig;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContractId() {
        return this.contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public RegistrationConfig getRegistrationConfig() {
        return this.registrationConfig;
    }

    public void setRegistrationConfig(RegistrationConfig registrationConfig) {
        this.registrationConfig = registrationConfig;
    }

    public ProfileConfig getProfileConfig() {
        return this.profileConfig;
    }

    public void setProfileConfig(ProfileConfig profileConfig) {
        this.profileConfig = profileConfig;
    }

    public boolean isRegistrationEnabled() {
        return this.isRegistrationEnabled;
    }

    public void setRegistrationEnabled(boolean registrationEnabled) {
        this.isRegistrationEnabled = registrationEnabled;
    }

    public boolean isProfileEnabled() {
        return this.isProfileEnabled;
    }

    public void setProfileEnabled(boolean profileEnabled) {
        this.isProfileEnabled = profileEnabled;
    }

    public List<LocalIdentityAuthSource> getAuthSources() {
        return this.authSources;
    }

    public List<String> getAuthSourceStrings() {
        return this.authSources.stream().map(LocalIdentityAuthSource::getSource).collect(Collectors.toList());
    }

    public void setAuthSources(List<LocalIdentityAuthSource> authSources) {
        this.authSources = authSources;
    }

    public FieldConfig getFieldConfig() {
        return this.fields;
    }

    public void setFieldConfig(FieldConfig fields) {
        this.fields = fields;
    }

    public EmailVerificationConfig getEmailOwnershipVerificationConfig() {
        return this.emailOwnershipVerificationConfig;
    }

    public void setEmailOwnershipVerificationConfig(EmailVerificationConfig emailOwnershipVerificationConfig) {
        this.emailOwnershipVerificationConfig = emailOwnershipVerificationConfig;
    }

    public DataStoreConfig getDataStoreConfig() {
        return this.dataStoreConfig;
    }

    public void setDataStoreConfig(DataStoreConfig dataStoreConfig) {
        this.dataStoreConfig = dataStoreConfig;
    }

    public LocalIdentityAuthSource getAuthSource(String authSourceName) {
        if (StringUtils.isBlank((String)authSourceName) || authSourceName.equals(REGISTRATION_ACTION_NAME)) {
            return LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE;
        }
        return this.getAuthSourceByName(authSourceName);
    }

    public String getAuthSourceId(String authSourceName) {
        LocalIdentityAuthSource authSource = this.getAuthSource(authSourceName);
        if (authSource == null) {
            return null;
        }
        return authSource.getId();
    }

    public LocalIdentityAuthSource getAuthSourceByName(String authSourceName) {
        for (LocalIdentityAuthSource source : this.authSources) {
            if (!source.getSource().equals(authSourceName)) continue;
            return source;
        }
        return null;
    }

    public LocalIdentityAuthSource getAuthSourceById(String id) {
        for (LocalIdentityAuthSource source : this.authSources) {
            if (!source.getId().equals(id)) continue;
            return source;
        }
        return null;
    }

    public String getPolicyActionStateKey() {
        return this.getId() + "-LOCAL_IDENTITY_PREVIOUS_REQUESTED_ACTION";
    }

    public LocalIdentityStorageManager<DN> getStorageManager() {
        LdapDataSource dataSource = this.getLdapDataSource(this.getDataStoreConfig());
        return LocalIdentityStorageManager.getInstance(dataSource.getLdapType());
    }

    private LdapDataSource getLdapDataSource(DataStoreConfig dataStoreConfig) {
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        return dataSourceManager.getLdapDataSource(dataStoreConfig.getAttributeSource().getDataSourceId());
    }

    public String getDnHandoffStateKey() {
        return PROFILE_MGMT_DN_HANDOFF + "." + this.id;
    }

    public String getProfileManagementSessionKey() {
        return "PROFILE_MGMT_SESSION_ATTRS." + this.id;
    }

    public String getTransactionIdKey() {
        return "PROFILE_MGMT_SESSION_ATTRS." + this.id + ".transactionId";
    }

    public void clearSession(SessionStateSupport sessionStateSupport, HttpServletRequest req, HttpServletResponse resp) {
        sessionStateSupport.removeAttribute(this.getProfileManagementSessionKey(), req, resp);
        sessionStateSupport.removeAttribute(this.getDnHandoffStateKey(), req, resp);
        sessionStateSupport.removeAttribute(this.getPolicyActionStateKey(), req, resp);
        sessionStateSupport.removeAttribute(this.getAdapterDnStateKey(), req, resp);
        sessionStateSupport.removeAttribute(this.getTransactionIdKey(), req, resp);
    }

    public String getAdapterDnStateKey() {
        return this.id + "-userDN";
    }
}

