/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.common.util.OtpUtils;
import com.pingidentity.localidentity.ConnectedIdentity;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LocalIdentityAuditLogger;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.type.EmailVerificationType;
import com.pingidentity.localidentity.type.LocalIdentityValidationResult;
import com.unboundid.ldap.sdk.DN;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.SendEmailVerification;
import org.sourceid.util.log.AttributeMap;

public final class LocalIdentityUtils {
    private static final Log log = LogFactory.getLog(LocalIdentityUtils.class);
    public static final String PROFILE_MANAGEMENT_ENDPOINT = "/pf/idprofile.ping";
    public static final String VERIFY_EMAIL_ENDPOINT = "/pf/id/verification.ping";
    public static final String LOCAL_IDENTITY_PROFILE_ID_PARAM_NAME = "LocalIdentityProfileID";
    public static final String JWT_QUERY_PARAM = "localidentity.a";
    public static final String VERIFY_STATUS_TRUE = "TRUE";
    public static final String VERIFY_STATUS_FALSE = "FALSE";

    private LocalIdentityUtils() {
    }

    public static String getProfileManagementPath() {
        return PROFILE_MANAGEMENT_ENDPOINT;
    }

    public static String getProfileManagementPathWithLipId(String lipId) {
        String pattern = "/pf/idprofile.ping?LocalIdentityProfileID=%s";
        return String.format(pattern, lipId);
    }

    public static String createConnectedIdentityValue(String authSourceId, String userId) {
        return String.format("auth-source=%s:user-id=%s", authSourceId, userId);
    }

    public static String createConnectedIdentityValue(ConnectedIdentity connectedIdentity) {
        return LocalIdentityUtils.createConnectedIdentityValue(connectedIdentity.getAuthSourceId(), connectedIdentity.getUserId());
    }

    public static String getSendEmailVerificationPath() {
        return VERIFY_EMAIL_ENDPOINT;
    }

    public static String getSendEmailVerificationPathWithLipId(String lipId) {
        String pattern = "/pf/id/verification.ping?LocalIdentityProfileID=%s";
        return String.format(pattern, lipId);
    }

    public static String getVerifyEmailPath() {
        return VERIFY_EMAIL_ENDPOINT;
    }

    public static String getFormattedUniqueId(LocalIdentityProfile localIdentityProfile, String uniqueIdValue) {
        FieldConfig fieldConfig = Optional.ofNullable(localIdentityProfile).map(LocalIdentityProfile::getFieldConfig).orElse(null);
        if (fieldConfig != null && fieldConfig.isStripSpaceFromUniqueField()) {
            return StringUtils.strip((String)uniqueIdValue);
        }
        return uniqueIdValue;
    }

    public static boolean isOtpEmailVerificationType(LocalIdentityProfile lip) {
        return lip.getEmailOwnershipVerificationConfig() != null && lip.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled() && EmailVerificationType.OTP.equals((Object)lip.getEmailOwnershipVerificationConfig().getEmailVerificationType());
    }

    public static LocalIdentityValidationResult validateOtp(HttpServletRequest req, HttpServletResponse resp, String otpSubmitted, LocalIdentityProfile lip, LocalIdentityDTO<DN> localIdentityDTO) {
        LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.VERIFY_OTP, localIdentityDTO, lip, null, req, resp);
        LocalIdentityAuditLogger.log();
        OtpUtils otpUtils = new OtpUtils();
        LocalIdentityValidationResult localIdentityValidationResult = new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Invalid, "otpInvalid");
        otpUtils.increaseOtpAttemptCount(req, resp);
        AttributeMap attributeMap = otpUtils.getStoredOtpAttributes(req, resp);
        if (attributeMap != null) {
            String userEmail = SendEmailVerification.getEmail(lip, localIdentityDTO.getAttributesForMapping());
            if (!otpUtils.isValidOtp(req, resp, otpSubmitted, userEmail)) {
                localIdentityValidationResult = new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Invalid, "otpInvalid");
            } else if (otpUtils.isExpiredOtp(req, resp, lip.getEmailOwnershipVerificationConfig().getOtpTimeToLive())) {
                localIdentityValidationResult = new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Expired, "otpExpired");
            } else {
                otpUtils.removeAllOtpAttributes(req, resp);
                return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Success);
            }
        }
        if (otpUtils.getOtpAttemptCount(req, resp) >= lip.getEmailOwnershipVerificationConfig().getOtpRetryAttempts()) {
            LocalIdentityAuditLogger.init(LocalIdentityAuditLogger.LocalIdentityAuditEvent.EXCEEDED_ATTEMPTS_FOR_OTP, localIdentityDTO, lip, null, req, resp);
            LocalIdentityAuditLogger.log();
            otpUtils.removeAllOtpAttributes(req, resp);
            return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.TooManyAttempts, "tooManyAttempts");
        }
        return localIdentityValidationResult;
    }
}

