/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity;

import com.pingidentity.common.util.LogGuard;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.websso.AuditLogger;

public class TrackedParamsAuditLogger
extends AuditLogger {
    private static final String LOGGING_PREFIX = "pf.tracked.param-";
    private static ThreadLocal<Collection<String>> TRACKED_PARAM_KEYS = ThreadLocal.withInitial(LinkedList::new);

    public static void setTrackedParams(Map<String, Collection<String>> theTrackedParams) {
        theTrackedParams.forEach((param, values) -> {
            String valueString = TrackedParamsAuditLogger.getValueString(values);
            if (StringUtils.isNotBlank((String)valueString)) {
                String key = LOGGING_PREFIX + param;
                TrackedParamsAuditLogger.put(key, valueString);
                TRACKED_PARAM_KEYS.get().add(key);
            }
        });
    }

    public static void cleanup() {
        for (String paramKey : TRACKED_PARAM_KEYS.get()) {
            ThreadContext.remove((String)paramKey);
        }
        TRACKED_PARAM_KEYS.remove();
    }

    public static String getTrackedParam(String paramName) {
        return ThreadContext.get((String)(LOGGING_PREFIX + paramName));
    }

    private static String getValueString(Collection<String> values) {
        if (values != null && !values.isEmpty()) {
            String valuesStr = StringUtils.join(values, (String)", ");
            return LogGuard.encode(valuesStr);
        }
        return null;
    }
}

