/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.fieldtypes;

import com.pingidentity.localidentity.fieldtypes.AbstractLocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.AbstractLocalIdentityFieldConfig;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.localidentity.data.StringFieldData;

public class DateField
extends AbstractLocalIdentityField<String> {
    private static final DateFieldConfig CONFIG = new DateFieldConfig();
    public static final String HTML5_DATE_EXPECTED_FORMAT = "yyyy-MM-dd";
    public static final String NAME = "Date";

    public DateField() {
    }

    public DateField(LocalIdentityFieldData data) {
        super(data);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractLocalIdentityFieldConfig getConfig() {
        return CONFIG;
    }

    @Override
    public LocalIdentityField newInstance(LocalIdentityFieldData data) {
        return new DateField(data);
    }

    @Override
    public List<ValidatorException> validateDefaultValue(String defaultValue, List<String> options) {
        ArrayList<ValidatorException> exceptions = new ArrayList<ValidatorException>();
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(HTML5_DATE_EXPECTED_FORMAT);
            LocalDate.parse(defaultValue, formatter);
        }
        catch (DateTimeParseException e) {
            String error = String.format("The default value of '%s' does not match the required date format of '%s'.", defaultValue, HTML5_DATE_EXPECTED_FORMAT);
            exceptions.add(new ValidatorException(error, ValidationConstraint.DATE_FORMAT));
        }
        return exceptions;
    }

    @Override
    public FieldData<String> getFieldData(String[] values) {
        return new StringFieldData(this.getData().getId(), this.isMultiValue(), values);
    }

    public static class DateFieldConfig
    extends AbstractLocalIdentityFieldConfig {
        @Override
        public List<String> getAttributes() {
            return Collections.unmodifiableList(Arrays.asList("Required", "Mask Log Values", "Read-Only"));
        }

        @Override
        public boolean isShowDefaultValueField() {
            return true;
        }

        @Override
        public boolean isShowOptionsField() {
            return false;
        }
    }
}

