/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.fieldtypes;

import com.pingidentity.localidentity.fieldtypes.CheckboxField;
import com.pingidentity.localidentity.fieldtypes.CheckboxGroupField;
import com.pingidentity.localidentity.fieldtypes.DateField;
import com.pingidentity.localidentity.fieldtypes.DropDownField;
import com.pingidentity.localidentity.fieldtypes.EmailField;
import com.pingidentity.localidentity.fieldtypes.HiddenField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.PhoneField;
import com.pingidentity.localidentity.fieldtypes.TextField;
import java.io.Serializable;
import org.sourceid.saml20.domain.LookupableLabel;

public enum LocalIdentityFieldType implements Serializable,
LookupableLabel
{
    TEXT("Text", new TextField()),
    DROPDOWN("Dropdown", new DropDownField()),
    DATE("Date", new DateField()),
    PHONE("Phone", new PhoneField()),
    EMAIL("Email", new EmailField()),
    CHECKBOX("Checkbox", new CheckboxField()),
    CHECKBOX_GROUP("Checkbox Group", new CheckboxGroupField()),
    HIDDEN("Hidden", new HiddenField());

    private String label;
    private LocalIdentityField field;

    private LocalIdentityFieldType(String label, LocalIdentityField field) {
        this.label = label;
        this.field = field;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public LocalIdentityField getField() {
        return this.field;
    }

    public static LocalIdentityFieldType fromObject(LocalIdentityField item) throws IllegalArgumentException {
        if (item instanceof TextField) {
            return TEXT;
        }
        if (item instanceof DropDownField) {
            return DROPDOWN;
        }
        if (item instanceof DateField) {
            return DATE;
        }
        if (item instanceof PhoneField) {
            return PHONE;
        }
        if (item instanceof EmailField) {
            return EMAIL;
        }
        if (item instanceof CheckboxField) {
            return CHECKBOX;
        }
        if (item instanceof CheckboxGroupField) {
            return CHECKBOX_GROUP;
        }
        if (item instanceof HiddenField) {
            return HIDDEN;
        }
        throw new IllegalArgumentException("No field type found for " + item.getClass());
    }
}

