/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.mgmt;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.localidentity.DataStoreAttribute;
import com.pingidentity.localidentity.DataStoreConfig;
import com.pingidentity.localidentity.EmailVerificationConfig;
import com.pingidentity.localidentity.ExecuteWorkflowSetting;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.localidentity.LdapDataStoreAttribute;
import com.pingidentity.localidentity.LdapDataStoreConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.ProfileConfig;
import com.pingidentity.localidentity.RegistrationConfig;
import com.pingidentity.localidentity.attrupdates.AuthSourceUpdatePolicy;
import com.pingidentity.localidentity.attrupdates.AuthSourceUpdatePolicyImpl;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSourceImpl;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldData;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityFieldType;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.localidentity.type.DefaultEmailVerificationConfig;
import com.pingidentity.localidentity.type.EmailVerificationType;
import com.pingidentity.x2017.x07.localIdentity.AppliesToType;
import com.pingidentity.x2017.x07.localIdentity.AuthSourceType;
import com.pingidentity.x2017.x07.localIdentity.AuthSourceUpdatePolicyType;
import com.pingidentity.x2017.x07.localIdentity.AuthSourcesType;
import com.pingidentity.x2017.x07.localIdentity.DataStoreAttributeType;
import com.pingidentity.x2017.x07.localIdentity.DataStoreConfigType;
import com.pingidentity.x2017.x07.localIdentity.DataStoreExtendedParamType;
import com.pingidentity.x2017.x07.localIdentity.EmailOwnershipVerificationConfigType;
import com.pingidentity.x2017.x07.localIdentity.FieldType;
import com.pingidentity.x2017.x07.localIdentity.FieldsConfigType;
import com.pingidentity.x2017.x07.localIdentity.LocalIdentityDocument;
import com.pingidentity.x2017.x07.localIdentity.LocalIdentityType;
import com.pingidentity.x2017.x07.localIdentity.ParameterType;
import com.pingidentity.x2017.x07.localIdentity.ProfileConfigType;
import com.pingidentity.x2017.x07.localIdentity.RegistrationConfigType;
import java.io.File;
import java.io.FileFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.metadata.partner.AttributeSourceConfigHelper;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeSourceType;
import org.sourceid.util.domain.SearchCriteria;
import org.sourceid.util.domain.SearchResult;
import org.sourceid.util.domain.Searchable;
import org.sourceid.util.domain.filter.ContainsCriteriaFilter;
import org.sourceid.util.domain.filter.ItemMultiValue;

public class LocalIdentityManagerImpl
implements LocalIdentityManager,
AutoReloadable {
    private static final Log LOG = LogFactory.getLog(LocalIdentityManagerImpl.class);
    private static final String PROFILES_DIR = "localidentity";
    private final XmlLoader xmlLoader;
    private final Map<String, LocalIdentityProfile> profileMap = new HashMap<String, LocalIdentityProfile>();
    private static final Comparator<LocalIdentityProfile> COMPARE_BY_NAME_DOWN = (lip1, lip2) -> lip1.getName().compareToIgnoreCase(lip2.getName());

    public LocalIdentityManagerImpl(XmlLoader xmlLoader, Mediator mediator) {
        this.xmlLoader = xmlLoader;
        this.loadConfig();
    }

    private synchronized void loadConfig() {
        FileFilter filter;
        File[] xmlFiles;
        this.profileMap.clear();
        File contractsDir = new File(this.getLocalIdentityPath());
        if (contractsDir.isDirectory() && (xmlFiles = contractsDir.listFiles(filter = file -> file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml"))) != null) {
            for (File xmlFile : xmlFiles) {
                this.loadXmlFile(xmlFile.getParent(), xmlFile.getName());
            }
        }
    }

    private void loadXmlFile(String directory, String filename) {
        XmlObject xmlObj = this.xmlLoader.load(directory, filename);
        if (xmlObj instanceof LocalIdentityDocument) {
            this.loadFromXmlDoc((LocalIdentityDocument)xmlObj);
        } else {
            LOG.warn((Object)("Unrecognized XML content in " + filename + ". Skipping file."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalIdentityProfile saveProfile(LocalIdentityProfile profile) {
        LocalIdentityManagerImpl localIdentityManagerImpl = this;
        synchronized (localIdentityManagerImpl) {
            try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
                boolean isUpdate;
                if (profile.getId() == null) {
                    profile.setId(IDGenerator.rndAlphaNumeric(16));
                    isUpdate = false;
                } else {
                    isUpdate = this.doDeleteProfile(profile.getId());
                }
                LocalIdentityDocument doc = this.convertToXmlDoc(profile);
                String filename = profile.getId() + ".xml";
                this.xmlLoader.save(this.getLocalIdentityPath(), filename, (XmlObject)doc);
                auditLoggerScope.log(AdminAuditLogger.Component.LOCAL_IDENTITY_PROFILE, isUpdate ? AdminAuditLogger.Event.MODIFY : AdminAuditLogger.Event.CREATE, profile.getName());
                this.loadXmlFile(this.getLocalIdentityPath(), filename);
            }
        }
        MgmtFactory.getAdapterManager().clearVirtualInstanceCache();
        MgmtFactory.getAdapterManager().clearLocalIdentityInstanceCache();
        return profile;
    }

    private String getLocalIdentityPath() {
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        return sysDirInfo.getDataDirectory() + File.separator + PROFILES_DIR;
    }

    @Override
    public synchronized void deleteProfile(String id) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.delete(this.getLocalIdentityPath(), id + ".xml");
            LocalIdentityProfile deleted = this.profileMap.remove(id);
            auditLoggerScope.log(AdminAuditLogger.Component.LOCAL_IDENTITY_PROFILE, AdminAuditLogger.Event.DELETE, deleted != null ? deleted.getName() : "");
        }
    }

    public synchronized boolean doDeleteProfile(String id) {
        this.xmlLoader.delete(this.getLocalIdentityPath(), id + ".xml");
        LocalIdentityProfile existing = this.profileMap.remove(id);
        return existing != null;
    }

    @Override
    public synchronized List<LocalIdentityProfile> getProfiles() {
        return new ArrayList<LocalIdentityProfile>(this.profileMap.values());
    }

    @Override
    public synchronized LocalIdentityProfile getProfile(String id) {
        return this.profileMap.get(id);
    }

    @Override
    public synchronized boolean isProfileInUse(String id) {
        return MgmtFactory.getAuthnSelectionConfigManager().isLocalIdentityProfileInUse(id) || MgmtFactory.getPolicyFragmentManager().isLocalIdentityProfileInUse(id) || !InUseDetectionUtil.getInstance().getIdpAdaptersWithLocalIdentityInUse(id).isEmpty();
    }

    @Override
    public synchronized List<String> getAllProfileNames() {
        return this.profileMap.values().stream().map(LocalIdentityProfile::getName).collect(Collectors.toList());
    }

    @Override
    public synchronized boolean isApcInUse(String contractId) {
        return this.profileMap.values().stream().anyMatch(localIdentityProfile -> localIdentityProfile.getContractId().equalsIgnoreCase(contractId));
    }

    @Override
    public synchronized boolean isFragmentInUse(String fragmentId) {
        return this.profileMap.values().stream().anyMatch(localIdentityProfile -> localIdentityProfile.getRegistrationConfig() != null && fragmentId.equals(localIdentityProfile.getRegistrationConfig().getRegistrationWorkflowFragmentId()));
    }

    @Override
    public synchronized Collection<LocalIdentityProfile> searchLocalIdentityProfile(Integer page, Integer numberPerPage, String filter) {
        SearchCriteria searchCriteria2;
        Searchable searchable = searchCriteria -> {
            ContainsCriteriaFilter<LocalIdentityProfile> filter1 = new ContainsCriteriaFilter<LocalIdentityProfile>(c -> new ItemMultiValue<LocalIdentityProfile, String>((LocalIdentityProfile)c, (K[])new String[]{c.getId(), c.getName()}));
            Collection searchResults = filter1.doFilter(searchCriteria.getQuery(), this.getProfiles().parallelStream().collect(Collectors.toList()));
            if (searchCriteria.getStartIndex() >= searchResults.size()) {
                return new SearchResult(searchCriteria.getStartIndex(), Collections.emptyList());
            }
            searchResults = searchResults.parallelStream().sorted(COMPARE_BY_NAME_DOWN).collect(Collectors.toList());
            if (searchCriteria.getItemsRequested() == -1) {
                return new SearchResult(0, new ArrayList(searchResults));
            }
            int fromIndex = searchCriteria.getStartIndex();
            int toIndex = searchCriteria.getStartIndex() + searchCriteria.getItemsRequested() >= searchResults.size() ? searchResults.size() : searchCriteria.getStartIndex() + searchCriteria.getItemsRequested();
            return new SearchResult(searchCriteria.getStartIndex(), new ArrayList(searchResults).subList(fromIndex, toIndex));
        };
        if (page == null) {
            searchCriteria2 = new SearchCriteria.Builder().query(filter).build();
        } else {
            int fromIndex = (page - 1) * numberPerPage;
            searchCriteria2 = new SearchCriteria.Builder(fromIndex, numberPerPage).query(filter).build();
        }
        SearchResult lipsSearchResult = searchable.search(searchCriteria2);
        return lipsSearchResult.getResults();
    }

    private void loadFromXmlDoc(LocalIdentityDocument doc) {
        LocalIdentityType localIdentityType = doc.getLocalIdentity();
        LocalIdentityProfile profile = new LocalIdentityProfile();
        profile.setId(localIdentityType.getProfileId());
        profile.setName(localIdentityType.getProfileName());
        profile.setContractId(localIdentityType.getContractId());
        profile.setRegistrationEnabled(localIdentityType.getRegistrationEnabled());
        profile.setProfileEnabled(localIdentityType.getProfileEnabled());
        profile.setAuthSources(this.parseAuthSourcesFromXML(localIdentityType));
        if (profile.isRegistrationEnabled() || profile.isProfileEnabled()) {
            profile.setFieldConfig(this.parseFieldConfigFromXML(localIdentityType));
        }
        if (profile.isRegistrationEnabled() || profile.isProfileEnabled()) {
            profile.setEmailOwnershipVerificationConfig(this.parseEmailOwnershipVerificationConfigFromXML(localIdentityType));
        }
        if (profile.isRegistrationEnabled()) {
            profile.setRegistrationConfig(this.parseRegistrationConfigFromXML(localIdentityType));
        }
        if (profile.isProfileEnabled()) {
            profile.setProfileConfig(this.parseProfileConfigFromXML(localIdentityType));
        }
        if (profile.isRegistrationEnabled() || profile.isProfileEnabled()) {
            profile.setDataStoreConfig(this.parseDataStoreConfigFromXML(localIdentityType));
        }
        if (this.profileMap.put(profile.getId(), profile) != null) {
            LOG.warn((Object)("A duplicate Local Identity Profile was loaded with ID '" + profile.getId() + "'. Overwriting previous profile."));
        }
    }

    private DataStoreConfig parseDataStoreConfigFromXML(LocalIdentityType localIdentityType) {
        DataStoreConfigType dataStoreConfigType = localIdentityType.getDatastoreMapping();
        localIdentityType.getDatastoreMapping().getDataSource();
        LdapDataStoreConfig mapping = null;
        HashMap<String, DataStoreAttribute> attrMap = new HashMap<String, DataStoreAttribute>(dataStoreConfigType.getAttributeArray().length);
        for (DataStoreAttributeType dataStoreAttribute : dataStoreConfigType.getAttributeArray()) {
            HashMap<String, String> extendedParams = new HashMap<String, String>(dataStoreAttribute.getParameterArray().length);
            for (DataStoreExtendedParamType extendedParam : dataStoreAttribute.getParameterArray()) {
                extendedParams.put(extendedParam.getParamName(), extendedParam.getValue());
            }
            LdapDataStoreAttribute attribute = new LdapDataStoreAttribute(dataStoreAttribute.getDatastoreField(), extendedParams);
            attrMap.put(dataStoreAttribute.getFieldName(), attribute);
        }
        AttributeSource attributeSource = AttributeSourceConfigHelper.createAttributeSourceFromXML(dataStoreConfigType.getDataSource());
        mapping = new LdapDataStoreConfig(attributeSource);
        mapping.setDataStoreMapping(attrMap);
        return mapping;
    }

    private FieldConfig parseFieldConfigFromXML(LocalIdentityType localIdentityType) {
        ArrayList localIdentityFields = new ArrayList();
        for (FieldType field : localIdentityType.getFields().getFieldArray()) {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            for (ParameterType param : field.getParameterArray()) {
                params.put(param.getParamName(), param.getValue());
            }
            ArrayList<String> options = new ArrayList<String>(field.getOptionsArray().length);
            Collections.addAll(options, field.getOptionsArray());
            LocalIdentityFieldData data = new LocalIdentityFieldData(field.getId(), field.getLabel(), field.getDefaultValue(), params, options, field.getAppliesTo().getRegistration(), field.getAppliesTo().getProfile());
            LocalIdentityFieldType type = LocalIdentityFieldType.valueOf(field.getType());
            localIdentityFields.add(type.getField().newInstance(data));
        }
        FieldConfig config = new FieldConfig(localIdentityFields);
        if (localIdentityType.getFields().isSetStripSpaceFromUniqueField()) {
            config.setStripSpaceFromUniqueField(localIdentityType.getFields().getStripSpaceFromUniqueField());
        } else {
            config.setStripSpaceFromUniqueField(false);
        }
        config.setMaskAllOgnlFields(localIdentityType.getFields().getMaskOgnlValues());
        return config;
    }

    private List<LocalIdentityAuthSource> parseAuthSourcesFromXML(LocalIdentityType localIdentityType) {
        ArrayList<LocalIdentityAuthSource> sources = new ArrayList<LocalIdentityAuthSource>();
        for (AuthSourceType source : localIdentityType.getAuthSources().getAuthSourceArray()) {
            AuthSourceUpdatePolicyType updatePolicyType = source.getUpdatePolicy();
            AuthSourceUpdatePolicyImpl updatePolicy = null;
            if (updatePolicyType != null) {
                Double updateIntervalInSeconds = updatePolicyType.getUpdateInterval() != null ? Double.valueOf(updatePolicyType.getUpdateInterval().doubleValue()) : null;
                updatePolicy = new AuthSourceUpdatePolicyImpl(updatePolicyType.getAttributeStorageEnabled(), updatePolicyType.getRetainAttributes(), updatePolicyType.getUpdateAttributes(), updateIntervalInSeconds);
            }
            sources.add(new LocalIdentityAuthSourceImpl(source.getId(), source.getName(), updatePolicy));
        }
        return sources;
    }

    private EmailVerificationConfig parseEmailOwnershipVerificationConfigFromXML(LocalIdentityType localIdentityType) {
        EmailOwnershipVerificationConfigType emailOwnershipVerificationConfigType = localIdentityType.getEmailVerificationConfig();
        EmailVerificationConfig config = null;
        if (emailOwnershipVerificationConfigType != null) {
            config = new EmailVerificationConfig();
            config.setEmailVerificationEnabled(emailOwnershipVerificationConfigType.getEmailVerificationEnabled());
            config.setVerifyEmailTemplateName(emailOwnershipVerificationConfigType.getVerifyEmailTemplateName());
            config.setEmailVerificationSentTemplateName(emailOwnershipVerificationConfigType.getEmailVerificationSentTemplateName());
            config.setEmailVerificationSuccessTemplateName(emailOwnershipVerificationConfigType.getEmailVerificationSuccessTemplateName());
            config.setEmailVerificationErrorTemplateName(emailOwnershipVerificationConfigType.getEmailVerificationErrorTemplateName());
            if (emailOwnershipVerificationConfigType.getEmailVerificationType() != null) {
                config.setEmailVerificationType(EmailVerificationType.valueOf(emailOwnershipVerificationConfigType.getEmailVerificationType()));
            }
            if (emailOwnershipVerificationConfigType.getOtpRetryAttempts() != null) {
                config.setOtpRetryAttempts(Integer.parseInt(emailOwnershipVerificationConfigType.getOtpRetryAttempts()));
            }
            if (emailOwnershipVerificationConfigType.getOtpLength() != null) {
                config.setOtpLength(Integer.parseInt(emailOwnershipVerificationConfigType.getOtpLength()));
            }
            if (emailOwnershipVerificationConfigType.getOtpTimeToLive() != null) {
                config.setOtpTimeToLive(Integer.parseInt(emailOwnershipVerificationConfigType.getOtpTimeToLive()));
            }
            config.setEmailVerificationOtpTemplateName(emailOwnershipVerificationConfigType.getEmailVerificationOtpTemplateName());
            config.setAllowedOtpCharacterSet(emailOwnershipVerificationConfigType.getAllowedOtpCharacterSet());
            config.setOtlTimeToLive(emailOwnershipVerificationConfigType.getOtlTimeToLive());
            config.setFieldUsedForOwnershipVerification(emailOwnershipVerificationConfigType.getVerificationEmailField());
            config.setFieldStoringVerificationStatus(emailOwnershipVerificationConfigType.getVerificationStatusField());
            config.setNotificationPublisherId(emailOwnershipVerificationConfigType.getNotificationPublisherId());
            config.setRequireVerifiedEmail(emailOwnershipVerificationConfigType.getRequireVerifiedEmail());
            config.setRequireVerifiedEmailTemplateName(emailOwnershipVerificationConfigType.getRequireVerifiedEmailTemplateName());
        } else {
            config = new DefaultEmailVerificationConfig();
        }
        return config;
    }

    private RegistrationConfig parseRegistrationConfigFromXML(LocalIdentityType localIdentityType) {
        RegistrationConfigType registrationConfigType = localIdentityType.getRegistrationConfig();
        RegistrationConfig config = new RegistrationConfig();
        config.setCaptchaEnabled(registrationConfigType.getCaptchaEnabled());
        config.setCaptchaProviderId(registrationConfigType.getCaptchaProviderId());
        config.setTemplateName(registrationConfigType.getTemplateName());
        config.setThisIsMyDeviceEnabled(registrationConfigType.getThisIsMyDevice());
        config.setCreateSessionAfterRegistration(registrationConfigType.getCreateAuthnSessionAfterRegistration());
        config.setFieldForUsername(registrationConfigType.getUsernameField());
        if (registrationConfigType.getRegistrationWorkflow() != null) {
            config.setRegistrationWorkflowFragmentId(registrationConfigType.getRegistrationWorkflow());
            String executeWorkflowSetting = registrationConfigType.getExecuteWorkflowSetting();
            if (executeWorkflowSetting == null) {
                executeWorkflowSetting = RegistrationConfig.DEFAULT_EXECUTE_WORKFLOW.getName();
            }
            config.setExecuteWorkflowSetting(executeWorkflowSetting);
        }
        return config;
    }

    private ProfileConfig parseProfileConfigFromXML(LocalIdentityType localIdentityType) {
        ProfileConfigType profileConfigType = localIdentityType.getProfileConfig();
        ProfileConfig config = new ProfileConfig();
        config.setDeleteIdentityEnabled(profileConfigType.getDeleteIdentityEnabled());
        config.setTemplateName(profileConfigType.getTemplateName());
        return config;
    }

    private LocalIdentityDocument convertToXmlDoc(LocalIdentityProfile profile) {
        LocalIdentityDocument doc = LocalIdentityDocument.Factory.newInstance();
        LocalIdentityType lipType = doc.addNewLocalIdentity();
        lipType.setProfileId(profile.getId());
        lipType.setProfileName(profile.getName());
        lipType.setContractId(profile.getContractId());
        lipType.setProfileEnabled(profile.isProfileEnabled());
        lipType.setRegistrationEnabled(profile.isRegistrationEnabled());
        lipType.setAuthSources(this.fillInAuthSources(lipType, profile));
        if (profile.isProfileEnabled() || profile.isRegistrationEnabled()) {
            this.fillInFieldTypeXML(lipType, profile);
        }
        if (profile.isProfileEnabled() || profile.isRegistrationEnabled()) {
            this.fillInEmailVerificationTypeXML(lipType, profile);
        }
        if (profile.isRegistrationEnabled()) {
            this.fillInRegistrationTypeXML(lipType, profile);
        }
        if (profile.isProfileEnabled()) {
            this.fillInProfileTypeXML(lipType, profile);
        }
        if (profile.isProfileEnabled() || profile.isRegistrationEnabled()) {
            this.fillInDataStoreConfigTypeXML(lipType, profile);
        }
        return doc;
    }

    private void fillInDataStoreConfigTypeXML(LocalIdentityType lipType, LocalIdentityProfile profile) {
        DataStoreConfigType dataStoreConfigType = lipType.addNewDatastoreMapping();
        DataStoreConfig mapping = profile.getDataStoreConfig();
        AttributeSourceType attributeSourceType = dataStoreConfigType.addNewDataSource();
        AttributeSourceConfigHelper.fillInAttributeSource(attributeSourceType, profile.getDataStoreConfig().getAttributeSource());
        for (Map.Entry<String, DataStoreAttribute> fieldMapping : mapping.getDataStoreMapping().entrySet()) {
            DataStoreAttributeType attributeType = dataStoreConfigType.addNewAttribute();
            attributeType.setFieldName(fieldMapping.getKey());
            attributeType.setDatastoreField(fieldMapping.getValue().getName());
            if (fieldMapping.getValue().getMetadata() == null) continue;
            for (Map.Entry<String, String> metadata : fieldMapping.getValue().getMetadata().entrySet()) {
                DataStoreExtendedParamType extendedParamType = attributeType.addNewParameter();
                extendedParamType.setParamName(metadata.getKey());
                extendedParamType.setValue(metadata.getValue());
            }
        }
    }

    private void fillInFieldTypeXML(LocalIdentityType lipType, LocalIdentityProfile profile) {
        FieldsConfigType fieldsType = lipType.addNewFields();
        for (LocalIdentityField<?> field : profile.getFieldConfig().getListOfAllFields()) {
            FieldType fieldType = fieldsType.addNewField();
            fieldType.setType(LocalIdentityFieldType.fromObject(field).name());
            fieldType.setDefaultValue(field.getData().getDefaultValue());
            fieldType.setId(field.getData().getId());
            fieldType.setOptionsArray(field.getData().getOptions().toArray(new String[0]));
            fieldType.setLabel(field.getData().getLabel());
            AppliesToType appliesToType = fieldType.addNewAppliesTo();
            appliesToType.setProfile(field.getData().isProfilePageField());
            appliesToType.setRegistration(field.getData().isRegistrationPageField());
            for (Map.Entry<String, Boolean> entry : field.getAttributes().entrySet()) {
                ParameterType param = fieldType.addNewParameter();
                param.setParamName(entry.getKey());
                param.setValue(entry.getValue().booleanValue());
            }
        }
        fieldsType.setStripSpaceFromUniqueField(profile.getFieldConfig().isStripSpaceFromUniqueField());
        fieldsType.setMaskOgnlValues(profile.getFieldConfig().isMaskAllOgnlFields());
    }

    private AuthSourcesType fillInAuthSources(LocalIdentityType lipType, LocalIdentityProfile profile) {
        AuthSourcesType type = lipType.addNewAuthSources();
        profile.getAuthSources().forEach(authSource -> {
            AuthSourceType authSourceType = type.addNewAuthSource();
            authSourceType.setId(authSource.getId());
            authSourceType.setName(authSource.getSource());
            AuthSourceUpdatePolicy updatePolicy = authSource.getUpdatePolicy();
            AuthSourceUpdatePolicyType updatePolicyType = authSourceType.addNewUpdatePolicy();
            updatePolicyType.setAttributeStorageEnabled(updatePolicy.isStoreAttributes());
            updatePolicyType.setRetainAttributes(updatePolicy.isRetainAttributes());
            updatePolicyType.setUpdateAttributes(updatePolicy.isUpdateAttributes());
            updatePolicyType.setUpdateInterval(BigDecimal.valueOf(updatePolicy.getUpdateInterval()));
        });
        return type;
    }

    private void fillInProfileTypeXML(LocalIdentityType lipType, LocalIdentityProfile profile) {
        ProfileConfigType profileConfigType = lipType.addNewProfileConfig();
        profileConfigType.setTemplateName(profile.getProfileConfig().getTemplateName());
        profileConfigType.setDeleteIdentityEnabled(profile.getProfileConfig().isDeleteIdentityEnabled());
    }

    private void fillInRegistrationTypeXML(LocalIdentityType lipType, LocalIdentityProfile profile) {
        String registrationWorkflowFragmentId;
        RegistrationConfigType registrationConfigType = lipType.addNewRegistrationConfig();
        registrationConfigType.setCaptchaEnabled(profile.getRegistrationConfig().isCaptchaEnabled());
        registrationConfigType.setCaptchaProviderId(profile.getRegistrationConfig().getCaptchaProviderId());
        registrationConfigType.setTemplateName(profile.getRegistrationConfig().getTemplateName());
        registrationConfigType.setThisIsMyDevice(profile.getRegistrationConfig().isThisIsMyDeviceEnabled());
        registrationConfigType.setCreateAuthnSessionAfterRegistration(profile.getRegistrationConfig().isCreateSessionAfterRegistration());
        if (profile.getRegistrationConfig().isCreateSessionAfterRegistration()) {
            registrationConfigType.setUsernameField(profile.getRegistrationConfig().getFieldForUsername());
        }
        if (StringUtils.isNotBlank((String)(registrationWorkflowFragmentId = profile.getRegistrationConfig().getRegistrationWorkflowFragmentId()))) {
            registrationConfigType.setRegistrationWorkflow(profile.getRegistrationConfig().getRegistrationWorkflowFragmentId());
            ExecuteWorkflowSetting executeWorkflowSetting = profile.getRegistrationConfig().getExecuteWorkflowSetting();
            if (executeWorkflowSetting == null) {
                executeWorkflowSetting = RegistrationConfig.DEFAULT_EXECUTE_WORKFLOW;
            }
            registrationConfigType.setExecuteWorkflowSetting(executeWorkflowSetting.getName());
        }
    }

    private void fillInEmailVerificationTypeXML(LocalIdentityType lipType, LocalIdentityProfile profile) {
        if (profile.getEmailOwnershipVerificationConfig() == null) {
            return;
        }
        EmailOwnershipVerificationConfigType emailOwnershipVerificationConfigType = lipType.addNewEmailVerificationConfig();
        emailOwnershipVerificationConfigType.setEmailVerificationEnabled(profile.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled());
        emailOwnershipVerificationConfigType.setVerifyEmailTemplateName(profile.getEmailOwnershipVerificationConfig().getVerifyEmailTemplateName());
        emailOwnershipVerificationConfigType.setEmailVerificationSentTemplateName(profile.getEmailOwnershipVerificationConfig().getEmailVerificationSentTemplateName());
        emailOwnershipVerificationConfigType.setEmailVerificationSuccessTemplateName(profile.getEmailOwnershipVerificationConfig().getEmailVerificationSuccessTemplateName());
        emailOwnershipVerificationConfigType.setEmailVerificationErrorTemplateName(profile.getEmailOwnershipVerificationConfig().getEmailVerificationErrorTemplateName());
        if (profile.getEmailOwnershipVerificationConfig().getEmailVerificationType() != null) {
            emailOwnershipVerificationConfigType.setEmailVerificationType(profile.getEmailOwnershipVerificationConfig().getEmailVerificationType().getType());
        }
        if (profile.getEmailOwnershipVerificationConfig().getOtpRetryAttempts() != null) {
            emailOwnershipVerificationConfigType.setOtpRetryAttempts(profile.getEmailOwnershipVerificationConfig().getOtpRetryAttempts().toString());
        }
        if (profile.getEmailOwnershipVerificationConfig().getOtpLength() != null) {
            emailOwnershipVerificationConfigType.setOtpLength(profile.getEmailOwnershipVerificationConfig().getOtpLength().toString());
        }
        if (profile.getEmailOwnershipVerificationConfig().getOtpTimeToLive() != null) {
            emailOwnershipVerificationConfigType.setOtpTimeToLive(profile.getEmailOwnershipVerificationConfig().getOtpTimeToLive().toString());
        }
        emailOwnershipVerificationConfigType.setEmailVerificationOtpTemplateName(profile.getEmailOwnershipVerificationConfig().getEmailVerificationOtpTemplateName());
        emailOwnershipVerificationConfigType.setAllowedOtpCharacterSet(profile.getEmailOwnershipVerificationConfig().getAllowedOtpCharacterSet());
        emailOwnershipVerificationConfigType.setOtlTimeToLive(profile.getEmailOwnershipVerificationConfig().getOtlTimeToLive());
        emailOwnershipVerificationConfigType.setVerificationEmailField(profile.getEmailOwnershipVerificationConfig().getFieldUsedForOwnershipVerification());
        emailOwnershipVerificationConfigType.setVerificationStatusField(profile.getEmailOwnershipVerificationConfig().getFieldStoringVerificationStatus());
        emailOwnershipVerificationConfigType.setNotificationPublisherId(profile.getEmailOwnershipVerificationConfig().getNotificationPublisherId());
        emailOwnershipVerificationConfigType.setRequireVerifiedEmail(profile.getEmailOwnershipVerificationConfig().isRequireVerifiedEmail());
        emailOwnershipVerificationConfigType.setRequireVerifiedEmailTemplateName(profile.getEmailOwnershipVerificationConfig().getRequireVerifiedEmailTemplateName());
    }
}

