/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class InitLogHelper {
    private static final String PF_HOME = "pf.home";

    private InitLogHelper() {
    }

    private static PrintStream initializeStream() throws IOException {
        File bootLogFile;
        File logDirFile = new File(System.getProperty(PF_HOME), "log");
        if (!logDirFile.exists() && !logDirFile.mkdirs()) {
            InitLogHelper.logErrorToConsole("Unable to create directory at " + logDirFile.getAbsolutePath());
        }
        if (!(bootLogFile = new File(logDirFile.getPath(), "init.log")).exists() && !bootLogFile.createNewFile()) {
            InitLogHelper.logErrorToConsole("Unable to create file at " + bootLogFile.getAbsolutePath());
        }
        return new PrintStream((OutputStream)new FileOutputStream(bootLogFile, true), false, "UTF-8");
    }

    private static void logErrorToConsole(String message) {
        System.err.println(message);
    }

    private static String getTimeString() {
        String INIT_LOG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss,SSS";
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date());
    }

    private static synchronized void writeLog(String message, Exception exception) {
        try (PrintStream initLog = InitLogHelper.initializeStream();){
            initLog.println(message);
            if (exception != null) {
                exception.printStackTrace(initLog);
            }
        }
        catch (IOException e) {
            InitLogHelper.logErrorToConsole(e.getMessage());
        }
    }

    public static void writeInfoLog(String message) {
        String output = InitLogHelper.getTimeString() + " " + message;
        InitLogHelper.writeLog(output, null);
    }

    public static void writeErrorLog(String message, Exception e) {
        String output = InitLogHelper.getTimeString() + " ERROR " + message;
        InitLogHelper.writeLog(output, e);
    }
}

