/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.log4j;

import com.pingidentity.jdbc.DBCPDataSourceFactory;
import com.pingidentity.jdbc.DBPoolSettings;
import com.pingidentity.log4j.InitLogHelper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pingidentity.utils.EnvironmentVariableUtil;

public class LoggingDBConnectionPoolFactory {
    private static final Logger debugIndicatorLogger = LogManager.getLogger((String)LoggingDBConnectionPoolFactory.class.getName());
    private static final Map<DB, DataSource> datasources = new HashMap<DB, DataSource>();
    private static final String LOG4J2_DB_PROPERTIES = "log4j2.db.properties";

    private LoggingDBConnectionPoolFactory() {
    }

    private static DataSource createDataSource(DB db) {
        Properties properties = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(LOG4J2_DB_PROPERTIES);){
            EnvironmentVariableUtil.loadPropertyWithEnvVar((Properties)properties, (InputStream)inputStream, (String)LOG4J2_DB_PROPERTIES);
        }
        catch (IOException e) {
            InitLogHelper.writeErrorLog("Error loading resource log4j2.db.properties", e);
        }
        DBPoolSettings settings = new DBPoolSettings(properties.getProperty(db.propertiesPrefix + ".url"), properties.getProperty(db.propertiesPrefix + ".username"), properties.getProperty(db.propertiesPrefix + ".password"));
        settings.setIntialSize(NumberUtils.toInt((String)properties.getProperty("initialSize"), (int)0));
        settings.setMaxTotal(NumberUtils.toInt((String)properties.getProperty("maxTotal"), (int)8));
        settings.setMaxIdle(NumberUtils.toInt((String)properties.getProperty("maxIdle"), (int)8));
        settings.setMinIdle(NumberUtils.toInt((String)properties.getProperty("minIdle"), (int)0));
        if (StringUtils.isNotBlank((String)properties.getProperty("defaultQueryTimeout"))) {
            settings.setDefaultQueryTimeout(NumberUtils.toInt((String)properties.getProperty("defaultQueryTimeout"), (int)60));
        }
        if (debugIndicatorLogger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Log4j2 Connection Pool Options ");
            sb.append("[").append(settings.getUrl()).append("]: ");
            sb.append("initialSize=").append(settings.getIntialSize()).append("; ");
            sb.append("maxTotal=").append(settings.getMaxTotal()).append("; ");
            sb.append("maxIdle=").append(settings.getMaxIdle()).append("; ");
            sb.append("minIdle=").append(settings.getMinIdle()).append("; ");
            InitLogHelper.writeInfoLog(sb.toString());
        }
        return DBCPDataSourceFactory.createDataSource(settings);
    }

    private static synchronized Connection getDatabaseConnection(DB db) throws SQLException {
        try {
            if (datasources.get((Object)db) != null) {
                return datasources.get((Object)db).getConnection();
            }
            DataSource datasource = LoggingDBConnectionPoolFactory.createDataSource(db);
            datasources.put(db, datasource);
            return datasource.getConnection();
        }
        catch (SQLException e) {
            InitLogHelper.writeErrorLog("Failed to connect to logging database", e);
            throw e;
        }
    }

    public static Connection getMySQLDatabaseConnection() throws SQLException {
        return LoggingDBConnectionPoolFactory.getDatabaseConnection(DB.MYSQL);
    }

    public static Connection getOracleDatabaseConnection() throws SQLException {
        return LoggingDBConnectionPoolFactory.getDatabaseConnection(DB.ORACLE);
    }

    public static Connection getSQLServerDatabaseConnection() throws SQLException {
        return LoggingDBConnectionPoolFactory.getDatabaseConnection(DB.SQL_SERVER);
    }

    public static Connection getPostgreSQLDatabaseConnection() throws SQLException {
        return LoggingDBConnectionPoolFactory.getDatabaseConnection(DB.POSTGRES);
    }

    private static enum DB {
        MYSQL("mysql"),
        ORACLE("oracle"),
        POSTGRES("postgres"),
        SQL_SERVER("sqlserver");

        private final String propertiesPrefix;

        private DB(String propertiesPrefix) {
            this.propertiesPrefix = propertiesPrefix;
        }
    }
}

