/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.module.connection;

import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleGlobalConfiguration;
import com.pingidentity.module.connection.ConnectionModuleManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.DependenciesType;

public class ConnectionModuleSupport {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String MODULE_DESCRIPTOR = "PF-INF/connection-module-runtime-descriptor";
    private static final String DESCRIPTOR_PROPERTIES_ID = "Module.Id";
    private static final String DESCRIPTOR_PROPERTIES_ROLES = "Roles";
    private static final String DESCRIPTOR_PROPERTIES_RUNTIME_MANAGER = "Runtime.Manager.Class";
    private static final String DESCRIPTOR_PROPERTIES_CONN_CONFIGURATION = "Connection.Configuration.Class";
    private static final String DESCRIPTOR_PROPERTIES_GLOBAL_CONFIGURATION = "Global.Configuration.Class";
    private final List<ModuleDescriptor> idpModuleDescriptors = this.generateModuleDescriptorList(Role.IDP);
    private final List<ModuleDescriptor> spModuleDescriptors = this.generateModuleDescriptorList(Role.SP);
    private static ConnectionModuleSupport instance = new ConnectionModuleSupport();

    private ConnectionModuleSupport() {
    }

    public static ConnectionModuleSupport getInstance() {
        return instance;
    }

    public ConnectionModuleManager getManager(Class<? extends ConnectionModuleConfiguration> moduleConfigType, Role connectionRole) {
        ConnectionModuleManager moduleManager = null;
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(connectionRole);
        if (moduleConfigType != null && moduleDescriptors != null) {
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (!moduleConfigType.getName().equals(moduleDescriptor.getConfigurationClassName())) continue;
                moduleManager = moduleDescriptor.createModuleManagerInstance();
                break;
            }
        }
        return moduleManager;
    }

    public ConnectionModuleManager getManagerFromGlobalConfiguration(Class<? extends ConnectionModuleGlobalConfiguration> moduleGlobalConfigType) {
        ConnectionModuleManager moduleManager = null;
        ArrayList<ModuleDescriptor> allModuleDescriptors = new ArrayList<ModuleDescriptor>();
        allModuleDescriptors.addAll(this.idpModuleDescriptors);
        allModuleDescriptors.addAll(this.spModuleDescriptors);
        if (moduleGlobalConfigType != null && allModuleDescriptors != null) {
            for (ModuleDescriptor moduleDescriptor : allModuleDescriptors) {
                if (!moduleGlobalConfigType.getName().equals(moduleDescriptor.getGlobalSettingsClassName())) continue;
                moduleManager = moduleDescriptor.createModuleManagerInstance();
                break;
            }
        }
        return moduleManager;
    }

    public List<ConnectionModuleConfiguration> getConfigurations(String entityId, Role connectionRole) {
        ArrayList<ConnectionModuleConfiguration> moduleConfigurationList = new ArrayList<ConnectionModuleConfiguration>();
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(connectionRole);
        if (moduleDescriptors != null) {
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                ConnectionModuleManager moduleManager = moduleDescriptor.createModuleManagerInstance();
                ConnectionModuleConfiguration moduleConfig = moduleManager.getConfiguration(entityId);
                if (moduleConfig == null) continue;
                moduleConfigurationList.add(moduleConfig);
            }
        }
        return moduleConfigurationList;
    }

    public List<ConnectionModuleGlobalConfiguration> getGlobalConfigurations() {
        ArrayList<ConnectionModuleGlobalConfiguration> globalConfigurations = new ArrayList<ConnectionModuleGlobalConfiguration>();
        ArrayList<ModuleDescriptor> allModuleDescriptors = new ArrayList<ModuleDescriptor>();
        allModuleDescriptors.addAll(this.idpModuleDescriptors);
        allModuleDescriptors.addAll(this.spModuleDescriptors);
        for (ModuleDescriptor moduleDescriptor : allModuleDescriptors) {
            ConnectionModuleManager moduleManager = moduleDescriptor.createModuleManagerInstance();
            ConnectionModuleGlobalConfiguration moduleGlobalConfiguration = moduleManager.getGlobalConfiguration();
            if (moduleGlobalConfiguration == null) continue;
            globalConfigurations.add(moduleGlobalConfiguration);
        }
        return globalConfigurations;
    }

    public void saveGlobalConfigurations(List<ConnectionModuleGlobalConfiguration> globalConfigurations) {
        if (globalConfigurations != null) {
            ArrayList<ModuleDescriptor> allModuleDescriptors = new ArrayList<ModuleDescriptor>();
            allModuleDescriptors.addAll(this.idpModuleDescriptors);
            allModuleDescriptors.addAll(this.spModuleDescriptors);
            block0: for (ConnectionModuleGlobalConfiguration globalConfiguration : globalConfigurations) {
                for (ModuleDescriptor moduleDescriptor : allModuleDescriptors) {
                    if (!moduleDescriptor.getGlobalSettingsClassName().equals(globalConfiguration.getClass().getName())) continue;
                    ConnectionModuleManager moduleManager = moduleDescriptor.createModuleManagerInstance();
                    moduleManager.saveGlobalConfiguration(globalConfiguration);
                    continue block0;
                }
            }
        }
    }

    public void getConfigurationsForExport(DependenciesType xmlDocumentType, String entityId, Role connectionRole) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(connectionRole);
        if (moduleDescriptors != null) {
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                ConnectionModuleManager moduleManager = moduleDescriptor.createModuleManagerInstance();
                moduleManager.exportConfiguration(xmlDocumentType, entityId);
            }
        }
    }

    public ConnectionModuleConfiguration createNewConfiguration(String moduleId, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (!moduleDescriptor.getId().equals(moduleId)) continue;
            Class<? extends ConnectionModuleConfiguration> configClass = moduleDescriptor.getConnectionModuleConfigurationClass();
            try {
                return configClass.newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        return null;
    }

    public ConnectionModuleConfiguration createConfigurationForImport(String configurationClassName, String xmlData, Role connectionRole, String entityIdFromConnection) {
        ConnectionModuleConfiguration moduleConfiguration = null;
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(connectionRole);
        if (moduleDescriptors != null) {
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (!moduleDescriptor.getConfigurationClassName().equals(configurationClassName)) continue;
                ConnectionModuleManager moduleManager = moduleDescriptor.createModuleManagerInstance();
                moduleConfiguration = moduleManager.createConfigurationForImport(entityIdFromConnection, xmlData);
                break;
            }
        }
        return moduleConfiguration;
    }

    public void validateConfigurationForImport(ConnectionModuleConfiguration moduleConfiguration, List<String> problems, Role connectionRole) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(connectionRole);
        if (moduleDescriptors != null) {
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                String moduleClassName = moduleConfiguration.getClass().getName();
                if (!moduleDescriptor.getConfigurationClassName().equals(moduleClassName)) continue;
                ConnectionModuleManager moduleManager = moduleDescriptor.createModuleManagerInstance();
                moduleManager.validateConfigurationForImport(moduleConfiguration, problems);
                break;
            }
        }
    }

    public Class<? extends ConnectionModuleConfiguration> getConnectionConfigurationClass(String moduleId, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (!moduleDescriptor.getId().equals(moduleId)) continue;
            return moduleDescriptor.getConnectionModuleConfigurationClass();
        }
        return null;
    }

    public Class<? extends ConnectionModuleGlobalConfiguration> getGlobalConfigurationClass(String moduleId, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (!moduleDescriptor.getId().equals(moduleId)) continue;
            return moduleDescriptor.getGlobalConfigurationClass();
        }
        return null;
    }

    public ConnectionModuleManager getManager(String moduleId, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (!moduleDescriptor.getId().equals(moduleId)) continue;
            return moduleDescriptor.createModuleManagerInstance();
        }
        return null;
    }

    public boolean moduleDefinesGlobalConfiguration(String moduleId, Role role) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (!moduleDescriptor.getId().equals(moduleId)) continue;
            return moduleDescriptor.getGlobalConfigurationClass() != null;
        }
        return false;
    }

    public boolean isDataSourceInUse(DataSource dataSource) {
        ArrayList<ModuleDescriptor> allModuleDescriptors = new ArrayList<ModuleDescriptor>();
        allModuleDescriptors.addAll(this.idpModuleDescriptors);
        allModuleDescriptors.addAll(this.spModuleDescriptors);
        for (ModuleDescriptor moduleDescriptor : allModuleDescriptors) {
            ConnectionModuleManager manager = moduleDescriptor.createModuleManagerInstance();
            if (!manager.isDataSourceInUse(dataSource)) continue;
            return true;
        }
        return false;
    }

    public List<ConnectionModuleManager> getIdpConnectionModulesWithDSInUse(DataSource dataSource) {
        LinkedList<ConnectionModuleManager> moduleDescriptors = new LinkedList<ConnectionModuleManager>();
        for (ModuleDescriptor idpModDesc : this.idpModuleDescriptors) {
            ConnectionModuleManager manager = idpModDesc.createModuleManagerInstance();
            if (!manager.isDataSourceInUse(dataSource)) continue;
            moduleDescriptors.add(manager);
        }
        return moduleDescriptors;
    }

    public boolean isIncludeConfigurationWithCopy(Role role, Class<? extends ConnectionModuleConfiguration> moduleConfigurationClass) {
        List<ModuleDescriptor> moduleDescriptors = this.getModuleDescriptors(role);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor.getConnectionModuleConfigurationClass() != moduleConfigurationClass) continue;
            ConnectionModuleManager moduleManager = moduleDescriptor.createModuleManagerInstance();
            return moduleManager.isIncludeWithConnectionCopy();
        }
        return false;
    }

    private List<ModuleDescriptor> getModuleDescriptors(Role connectionRole) {
        List<ModuleDescriptor> moduleDescriptors = null;
        if (connectionRole == Role.IDP) {
            moduleDescriptors = this.idpModuleDescriptors;
        } else if (connectionRole == Role.SP) {
            moduleDescriptors = this.spModuleDescriptors;
        } else {
            this.log.error((Object)("Invalid connectionRole :" + connectionRole));
        }
        return moduleDescriptors;
    }

    private List<ModuleDescriptor> generateModuleDescriptorList(Role roleToGenerate) {
        ArrayList<ModuleDescriptor> moduleDescriptorList = new ArrayList<ModuleDescriptor>();
        Enumeration<URL> resources = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> en = resources = classLoader.getResources(MODULE_DESCRIPTOR);
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                try {
                    Object content = url.getContent();
                    if (!(content instanceof InputStream)) continue;
                    InputStream is = (InputStream)content;
                    Properties properties = new Properties();
                    properties.load(is);
                    String moduleRoles = properties.getProperty(DESCRIPTOR_PROPERTIES_ROLES).trim();
                    StringTokenizer stringTokenizer = new StringTokenizer(moduleRoles, ",");
                    while (stringTokenizer.hasMoreElements()) {
                        String role = (String)stringTokenizer.nextElement();
                        if (!roleToGenerate.toString().equalsIgnoreCase(role)) continue;
                        String moduleId = properties.getProperty(DESCRIPTOR_PROPERTIES_ID).trim();
                        String moduleManagerName = properties.getProperty(DESCRIPTOR_PROPERTIES_RUNTIME_MANAGER).trim();
                        String moduleConfigurationName = properties.getProperty(DESCRIPTOR_PROPERTIES_CONN_CONFIGURATION).trim();
                        String moduleGlobalConfigurationName = properties.getProperty(DESCRIPTOR_PROPERTIES_GLOBAL_CONFIGURATION).trim();
                        ModuleDescriptor moduleDescriptor = new ModuleDescriptor(moduleId, moduleManagerName, moduleConfigurationName, moduleGlobalConfigurationName);
                        moduleDescriptorList.add(moduleDescriptor);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return moduleDescriptorList;
    }

    public void reloadConfigurations() {
        for (ModuleDescriptor moduleDescriptor : this.idpModuleDescriptors) {
            moduleDescriptor.createModuleManagerInstance().reload();
        }
        for (ModuleDescriptor moduleDescriptor : this.spModuleDescriptors) {
            moduleDescriptor.createModuleManagerInstance().reload();
        }
    }

    private class ModuleDescriptor {
        private String id;
        private String managerClassName;
        private String configurationClassName;
        private String globalConfigurationClassName;

        public ModuleDescriptor(String moduleId, String manager, String configuration, String globalConfiguration) {
            this.id = moduleId;
            this.managerClassName = manager;
            this.configurationClassName = configuration;
            this.globalConfigurationClassName = globalConfiguration;
        }

        public String getId() {
            return this.id;
        }

        public String getManagerClassName() {
            return this.managerClassName;
        }

        public String getConfigurationClassName() {
            return this.configurationClassName;
        }

        public String getGlobalSettingsClassName() {
            return this.globalConfigurationClassName;
        }

        public String toString() {
            return "Module Id : " + this.id + ", Manager : " + this.managerClassName + ", Configuration : " + this.configurationClassName + ", Global Configuration : " + this.globalConfigurationClassName;
        }

        public ConnectionModuleManager createModuleManagerInstance() {
            return (ConnectionModuleManager)this.createModuleClassInstance(this.managerClassName);
        }

        public Class<? extends ConnectionModuleConfiguration> getConnectionModuleConfigurationClass() {
            return this.getClass(this.configurationClassName);
        }

        public Class<? extends ConnectionModuleGlobalConfiguration> getGlobalConfigurationClass() {
            return this.getClass(this.globalConfigurationClassName);
        }

        public Class<? extends ConnectionModuleManager> getManagerClass() {
            return this.getClass(this.managerClassName);
        }

        private Class<?> getClass(String className) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return clazz;
        }

        public Object createModuleClassInstance(String className) {
            Log log = LogFactory.getLog((String)"ConnectionModuleSupport");
            Object classFromModule = null;
            try {
                Class<?> moduleClass = Class.forName(className);
                classFromModule = moduleClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Error creating instance of " + className + ".  Class not found."));
            }
            catch (InstantiationException e) {
                log.error((Object)("Error creating instance of " + className + ".  Instantiation exception."));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Error creating instance of " + className + ".  Illegal access exception."));
            }
            return classFromModule;
        }
    }
}

